"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogSourcesSettingDeprecationInfo = void 0;
var _i18n = require("@kbn/i18n");
var _log_views = require("../../common/log_views");
var _deprecations = require("../../common/http_api/deprecations");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLogSourcesSettingDeprecationInfo = async ({
  getStartServices,
  context
}) => {
  const [_, pluginStartDeps, pluginStart] = await getStartServices();
  const logSourcesService = pluginStartDeps.logsDataAccess.services.logSourcesServiceFactory.getLogSourcesService(context.savedObjectsClient);
  const logViewsClient = pluginStart.logViews.getClient(context.savedObjectsClient, context.esClient.asCurrentUser, logSourcesService);
  const logView = await logViewsClient.getLogView(_log_views.defaultLogViewId);
  if (logView && !_common.logSourcesKibanaAdvancedSettingRT.is(logView.attributes.logIndices)) {
    return [{
      title: _i18n.i18n.translate('xpack.logsShared.deprecations.migrateLogViewSettingsToLogSourcesSetting.title', {
        defaultMessage: 'Log sources setting'
      }),
      level: 'warning',
      deprecationType: 'feature',
      message: _i18n.i18n.translate('xpack.logsShared.deprecations.migrateLogViewSettingsToLogSourcesSetting.message', {
        defaultMessage: 'Indices and Data view options previously provided via the Logs UI settings page are now deprecated. Please migrate to using the Kibana log sources advanced setting.'
      }),
      correctiveActions: {
        manualSteps: [_i18n.i18n.translate('xpack.logsShared.deprecations.migrateLogViewSettingsToLogSourcesSetting.message.manualStepMessage', {
          defaultMessage: 'Update the Log sources Kibana advanced setting (via Management > Advanced Settings) to match the setting previously provided via the Logs UI settings page. Then via the Logs UI settings page use the Kibana log sources advanced setting option.'
        })],
        api: {
          method: 'PUT',
          path: _deprecations.MIGRATE_LOG_VIEW_SETTINGS_URL
        }
      }
    }];
  } else {
    return [];
  }
};
exports.getLogSourcesSettingDeprecationInfo = getLogSourcesSettingDeprecationInfo;