"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsSharedPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _locators = require("../common/locators");
var _log_ai_assistant = require("./components/log_ai_assistant");
var _logs_overview = require("./components/logs_overview");
var _log_views = require("./services/log_views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogsSharedPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "logViews", void 0);
    this.logViews = new _log_views.LogViewsService();
  }
  setup(_, pluginsSetup) {
    const logViews = this.logViews.setup();
    const logsLocator = pluginsSetup.share.url.locators.create(new _locators.LogsLocatorDefinition(pluginsSetup.share.url.locators));
    const nodeLogsLocator = pluginsSetup.share.url.locators.create(new _locators.NodeLogsLocatorDefinition(pluginsSetup.share.url.locators));
    const traceLogsLocator = pluginsSetup.share.url.locators.create(new _locators.TraceLogsLocatorDefinition(pluginsSetup.share.url.locators));
    const locators = {
      logsLocator,
      nodeLogsLocator,
      traceLogsLocator
    };
    return {
      logViews,
      locators
    };
  }
  start(core, plugins) {
    const {
      http,
      settings
    } = core;
    const {
      charts,
      data,
      dataViews,
      discoverShared,
      logsDataAccess,
      observabilityAIAssistant,
      share
    } = plugins;
    const logViews = this.logViews.start({
      http,
      dataViews,
      logSourcesService: logsDataAccess.services.logSourcesService,
      search: data.search
    });
    const LogsOverview = (0, _logs_overview.createLogsOverview)({
      charts,
      logsDataAccess,
      search: data.search.search,
      uiSettings: settings,
      share
    });
    if (!observabilityAIAssistant) {
      return {
        logViews,
        LogsOverview
      };
    }
    const LogAIAssistant = (0, _log_ai_assistant.createLogAIAssistant)({
      observabilityAIAssistant
    });
    discoverShared.features.registry.register({
      id: 'observability-logs-ai-assistant',
      render: (0, _log_ai_assistant.createLogsAIAssistantRenderer)(LogAIAssistant)
    });
    return {
      logViews,
      LogAIAssistant,
      LogsOverview
    };
  }
  stop() {}
}
exports.LogsSharedPlugin = LogsSharedPlugin;