"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogsLocatorsFromUrlService = void 0;
var _logs_locator = require("./logs_locator");
var _node_logs_locator = require("./node_logs_locator");
var _trace_logs_locator = require("./trace_logs_locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLogsLocatorsFromUrlService = urlService => {
  const logsLocator = urlService.locators.get(_logs_locator.LOGS_LOCATOR_ID);
  const nodeLogsLocator = urlService.locators.get(_node_logs_locator.NODE_LOGS_LOCATOR_ID);
  const traceLogsLocator = urlService.locators.get(_trace_logs_locator.TRACE_LOGS_LOCATOR_ID);
  return {
    logsLocator,
    traceLogsLocator,
    nodeLogsLocator
  };
};
exports.getLogsLocatorsFromUrlService = getLogsLocatorsFromUrlService;