"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resourceLabel = exports.resourceHeaderTooltipParagraph = exports.openCellActionPopoverAriaText = exports.filterOutText = exports.filterForText = exports.copyValueText = exports.copyValueAriaText = exports.contentLabel = exports.contentHeaderTooltipParagraph2 = exports.contentHeaderTooltipParagraph1 = exports.closeCellActionPopoverText = exports.actionFilterOutText = exports.actionFilterForText = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const contentLabel = exports.contentLabel = _i18n.i18n.translate('xpack.logsExplorer.dataTable.header.popover.content', {
  defaultMessage: 'Content'
});
const resourceLabel = exports.resourceLabel = _i18n.i18n.translate('xpack.logsExplorer.dataTable.header.popover.resource', {
  defaultMessage: 'Resource'
});
const actionFilterForText = text => _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.value.hover.filterFor', {
  defaultMessage: 'Filter for this {value}',
  values: {
    value: text
  }
});
exports.actionFilterForText = actionFilterForText;
const actionFilterOutText = text => _i18n.i18n.translate('xpack.logsExplorer.flyoutDetail.value.hover.filterOut', {
  defaultMessage: 'Filter out this {value}',
  values: {
    value: text
  }
});
exports.actionFilterOutText = actionFilterOutText;
const filterOutText = exports.filterOutText = _i18n.i18n.translate('xpack.logsExplorer.popoverAction.filterOut', {
  defaultMessage: 'Filter out'
});
const filterForText = exports.filterForText = _i18n.i18n.translate('xpack.logsExplorer.popoverAction.filterFor', {
  defaultMessage: 'Filter for'
});
const copyValueText = exports.copyValueText = _i18n.i18n.translate('xpack.logsExplorer.popoverAction.copyValue', {
  defaultMessage: 'Copy value'
});
const copyValueAriaText = fieldName => _i18n.i18n.translate('xpack.logsExplorer.popoverAction.copyValueAriaText', {
  defaultMessage: 'Copy value of {fieldName}',
  values: {
    fieldName
  }
});
exports.copyValueAriaText = copyValueAriaText;
const openCellActionPopoverAriaText = exports.openCellActionPopoverAriaText = _i18n.i18n.translate('xpack.logsExplorer.popoverAction.openPopover', {
  defaultMessage: 'Open popover'
});
const closeCellActionPopoverText = exports.closeCellActionPopoverText = _i18n.i18n.translate('xpack.logsExplorer.popoverAction.closePopover', {
  defaultMessage: 'Close popover'
});
const contentHeaderTooltipParagraph1 = exports.contentHeaderTooltipParagraph1 = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.logsExplorer.dataTable.header.content.tooltip.paragraph1",
  defaultMessage: "Displays the document's {logLevel} and {message} fields.",
  values: {
    // eslint-disable-next-line @kbn/i18n/strings_should_be_translated_with_i18n
    logLevel: /*#__PURE__*/_react.default.createElement("strong", null, "log.level"),
    // eslint-disable-next-line @kbn/i18n/strings_should_be_translated_with_i18n
    message: /*#__PURE__*/_react.default.createElement("strong", null, "message")
  }
});
const contentHeaderTooltipParagraph2 = exports.contentHeaderTooltipParagraph2 = _i18n.i18n.translate('xpack.logsExplorer.dataTable.header.content.tooltip.paragraph2', {
  defaultMessage: 'When the message field is empty, one of the following is displayed:'
});
const resourceHeaderTooltipParagraph = exports.resourceHeaderTooltipParagraph = _i18n.i18n.translate('xpack.logsExplorer.dataTable.header.resource.tooltip.paragraph', {
  defaultMessage: "Fields that provide information on the document's source, such as:"
});