"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * uiSettings definitions for the logs_data_access plugin.
 */
const uiSettings = exports.uiSettings = {
  [_managementSettingsIds.OBSERVABILITY_LOGS_DATA_ACCESS_LOG_SOURCES_ID]: {
    category: ['observability'],
    name: _i18n.i18n.translate('xpack.logsDataAccess.logSources', {
      defaultMessage: 'Log sources'
    }),
    value: _constants.DEFAULT_LOG_SOURCES,
    description: _i18n.i18n.translate('xpack.logsDataAccess.logSourcesDescription', {
      defaultMessage: 'Sources to be used for logs data. If the data contained in these indices is not logs data, you may experience degraded functionality. Changes to this setting can potentially impact the sources queried in Log Threshold rules.'
    }),
    type: 'array',
    schema: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    requiresPageReload: true
  }
};