"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.patchListRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _zodHelpers = require("@kbn/zod-helpers");
var _api = require("@kbn/securitysolution-lists-common/api");
var _utils = require("../utils");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const patchListRoute = router => {
  router.versioned.patch({
    access: 'public',
    options: {
      tags: ['access:lists-all']
    },
    path: _securitysolutionListConstants.LIST_URL
  }).addVersion({
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_api.PatchListRequestBody)
      }
    },
    version: '2023-10-31'
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const {
        name,
        description,
        id,
        meta,
        _version,
        version
      } = request.body;
      const lists = await (0, _.getListClient)(context);
      const dataStreamExists = await lists.getListDataStreamExists();
      // needs to be migrated to data stream if index exists
      if (!dataStreamExists) {
        const indexExists = await lists.getListIndexExists();
        if (indexExists) {
          await lists.migrateListIndexToDataStream();
        }
      }
      const list = await lists.patchList({
        _version,
        description,
        id,
        meta,
        name,
        version
      });
      if (list == null) {
        return siemResponse.error({
          body: `list id: "${id}" not found`,
          statusCode: 404
        });
      }
      return response.ok({
        body: _api.PatchListResponse.parse(list)
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.patchListRoute = patchListRoute;