"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksStorage = void 0;
var _contentManagementUtils = require("@kbn/content-management-utils");
var _common = require("../../common");
var _cm_services = require("./schema/cm_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class LinksStorage extends _contentManagementUtils.SOContentStorage {
  constructor({
    logger,
    throwOnResultValidationError
  }) {
    super({
      savedObjectType: _common.CONTENT_ID,
      cmServicesDefinition: _cm_services.cmServicesDefinition,
      enableMSearch: true,
      allowedSavedObjectAttributes: ['id', 'title', 'description', 'links', 'layout'],
      logger,
      throwOnResultValidationError
    });
  }
}
exports.LinksStorage = LinksStorage;