"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksPlugin = void 0;
var _public = require("@kbn/dashboard-plugin/public");
var _common = require("../common");
var _links_strings = require("./components/links_strings");
var _links_content_management_client = require("./content_management/links_content_management_client");
var _kibana_services = require("./services/kibana_services");
var _create_links_panel_action = require("./actions/create_links_panel_action");
var _deserialize_from_library = require("./lib/deserialize_from_library");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class LinksPlugin {
  constructor() {}
  setup(core, plugins) {
    core.getStartServices().then(([_, deps]) => {
      plugins.contentManagement.registry.register({
        id: _common.CONTENT_ID,
        version: {
          latest: _common.LATEST_VERSION
        },
        name: _common.APP_NAME
      });
      plugins.embeddable.registerReactEmbeddableSavedObject({
        onAdd: async (container, savedObject) => {
          const initialState = await (0, _deserialize_from_library.deserializeLinksSavedObject)(savedObject);
          container.addNewPanel({
            panelType: _common.CONTENT_ID,
            initialState
          });
        },
        embeddableType: _common.CONTENT_ID,
        savedObjectType: _common.CONTENT_ID,
        savedObjectName: _common.APP_NAME,
        getIconForSavedObject: () => _common.APP_ICON
      });
      plugins.embeddable.registerReactEmbeddableFactory(_common.CONTENT_ID, async () => {
        const {
          getLinksEmbeddableFactory
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/links_embeddable')));
        return getLinksEmbeddableFactory();
      });
      plugins.visualizations.registerAlias({
        disableCreate: true,
        // do not allow creation through visualization listing page
        name: _common.CONTENT_ID,
        title: _common.APP_NAME,
        icon: _common.APP_ICON,
        description: _links_strings.LinksStrings.getDescription(),
        stage: 'production',
        appExtensions: {
          visualizations: {
            docTypes: [_common.CONTENT_ID],
            searchFields: ['title^3'],
            client: _links_content_management_client.getLinksClient,
            toListItem(linkItem) {
              const {
                id,
                type,
                updatedAt,
                attributes
              } = linkItem;
              const {
                title,
                description
              } = attributes;
              return {
                id,
                title,
                editor: {
                  onEdit: async savedObjectId => {
                    const {
                      openEditorFlyout
                    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./editor/open_editor_flyout')));
                    const linksSavedObject = await (0, _links_content_management_client.getLinksClient)().get(savedObjectId);
                    const initialState = await (0, _deserialize_from_library.deserializeLinksSavedObject)(linksSavedObject.item);
                    await openEditorFlyout({
                      initialState
                    });
                  }
                },
                description,
                updatedAt,
                icon: _common.APP_ICON,
                typeTitle: _common.APP_NAME,
                stage: 'production',
                savedObjectType: type
              };
            }
          }
        }
      });
    });
  }
  start(core, plugins) {
    (0, _kibana_services.setKibanaServices)(core, plugins);
    (0, _kibana_services.untilPluginStartServicesReady)().then(() => {
      (0, _create_links_panel_action.registerCreateLinksPanelAction)();
      plugins.dashboard.registerDashboardPanelPlacementSetting(_common.CONTENT_ID, async runtimeState => {
        var _runtimeState$links$l, _runtimeState$links;
        if (!runtimeState) return {};
        const isHorizontal = runtimeState.layout === 'horizontal';
        const width = isHorizontal ? _public.DASHBOARD_GRID_COLUMN_COUNT : 8;
        const height = isHorizontal ? 4 : ((_runtimeState$links$l = (_runtimeState$links = runtimeState.links) === null || _runtimeState$links === void 0 ? void 0 : _runtimeState$links.length) !== null && _runtimeState$links$l !== void 0 ? _runtimeState$links$l : 1 * 3) + 4;
        return {
          width,
          height,
          strategy: _public.PanelPlacementStrategy.placeAtTop
        };
      });
    });
    return {};
  }
  stop() {}
}
exports.LinksPlugin = LinksPlugin;