"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.linksSerializeStateIsByReference = exports.deserializeLinksSavedObject = void 0;
var _persistable_state = require("../../common/persistable_state");
var _resolve_links = require("./resolve_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const linksSerializeStateIsByReference = state => {
  return Boolean(state && state.savedObjectId !== undefined);
};
exports.linksSerializeStateIsByReference = linksSerializeStateIsByReference;
const deserializeLinksSavedObject = async linksSavedObject => {
  var _attributes$links;
  if (linksSavedObject.error) throw linksSavedObject.error;
  const {
    attributes
  } = (0, _persistable_state.injectReferences)(linksSavedObject);
  const links = await (0, _resolve_links.resolveLinks)((_attributes$links = attributes.links) !== null && _attributes$links !== void 0 ? _attributes$links : []);
  const {
    title: defaultPanelTitle,
    description: defaultPanelDescription,
    layout
  } = attributes;
  return {
    links,
    layout,
    savedObjectId: linksSavedObject.id,
    defaultPanelTitle,
    defaultPanelDescription
  };
};
exports.deserializeLinksSavedObject = deserializeLinksSavedObject;