"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DimensionDataExtraEditor = DimensionDataExtraEditor;
exports.DimensionEditor = DimensionEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./toolbar.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _coloring = require("@kbn/coloring");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _visualizationUtils = require("@kbn/visualization-utils");
var _eui = require("@elastic/eui");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _shared_components = require("../../shared_components");
var _collapse_setting = require("../../shared_components/collapse_setting");
var _visualization = require("./visualization");
var _lens_ui_telemetry = require("../../lens_ui_telemetry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DimensionEditor(props) {
  var _props$frame$activeDa, _table$rows, _currentLayer$colorMa, _currentLayer$colorsB;
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _visualizationUtils.useDebouncedValue)({
    value: props.state,
    onChange: props.setState
  });
  const currentLayer = localState.layers.find(layer => layer.layerId === props.layerId);
  const canUseColorMapping = currentLayer && currentLayer.colorMapping ? true : false;
  const [useNewColorMapping, setUseNewColorMapping] = (0, _react.useState)(canUseColorMapping);
  const setConfig = (0, _react.useCallback)(({
    color
  }) => {
    if (!currentLayer) {
      return;
    }
    const newColorsByDimension = {
      ...currentLayer.colorsByDimension
    };
    if (color) {
      newColorsByDimension[props.accessor] = color;
    } else {
      delete newColorsByDimension[props.accessor];
    }
    setLocalState({
      ...localState,
      layers: localState.layers.map(layer => layer.layerId === currentLayer.layerId ? {
        ...layer,
        colorsByDimension: newColorsByDimension
      } : layer)
    });
  }, [currentLayer, localState, props.accessor, setLocalState]);
  const setColorMapping = (0, _react.useCallback)(colorMapping => {
    setLocalState({
      ...localState,
      layers: localState.layers.map(layer => layer.layerId === (currentLayer === null || currentLayer === void 0 ? void 0 : currentLayer.layerId) ? {
        ...layer,
        colorMapping
      } : layer)
    });
  }, [localState, currentLayer, setLocalState]);
  if (!currentLayer) {
    return null;
  }
  const firstNonCollapsedColumnId = currentLayer.primaryGroups.find(id => !(0, _visualization.isCollapsed)(id, currentLayer));
  const showColorPicker = currentLayer.metrics.includes(props.accessor) && currentLayer.allowMultipleMetrics;
  const colorPickerDisabledMessage = (0, _visualization.hasNonCollapsedSliceBy)(currentLayer) ? ['pie', 'donut'].includes(props.state.shape) ? _i18n.i18n.translate('xpack.lens.pieChart.colorPicker.disabledBecauseSliceBy', {
    defaultMessage: 'You are unable to apply custom colors to individual slices when the layer includes one or more "Slice by" dimensions.'
  }) : _i18n.i18n.translate('xpack.lens.pieChart.colorPicker.disabledBecauseGroupBy', {
    defaultMessage: 'You are unable to apply custom colors to individual slices when the layer includes one or more "Group by" dimensions.'
  }) : undefined;
  const colors = (0, _coloring.getColorsFromMapping)(props.isDarkMode, currentLayer.colorMapping);
  const table = (_props$frame$activeDa = props.frame.activeData) === null || _props$frame$activeDa === void 0 ? void 0 : _props$frame$activeDa[currentLayer.layerId];
  const splitCategories = (0, _chartExpressionsCommon.getColorCategories)((_table$rows = table === null || table === void 0 ? void 0 : table.rows) !== null && _table$rows !== void 0 ? _table$rows : [], props.accessor);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, props.accessor === firstNonCollapsedColumnId && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.colorMapping.editColorMappingSectionLabel', {
      defaultMessage: 'Color mapping'
    }),
    style: {
      alignItems: 'center'
    },
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_shared_components.PalettePanelContainer, {
    palette: colors,
    siblingRef: props.panelRef,
    title: useNewColorMapping ? _i18n.i18n.translate('xpack.lens.colorMapping.editColorMappingTitle', {
      defaultMessage: 'Assign colors to terms'
    }) : _i18n.i18n.translate('xpack.lens.colorMapping.editColorsTitle', {
      defaultMessage: 'Edit colors'
    }),
    isInlineEditing: props.isInlineEditing
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsPalettePanel__section lnsPalettePanel__section--shaded lnsIndexPatternDimensionEditor--padded"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.lens.colorMapping.tryLabel', {
      defaultMessage: 'Use the new Color Mapping feature'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, _i18n.i18n.translate('xpack.lens.colorMapping.techPreviewLabel', {
      defaultMessage: 'Tech preview'
    })))),
    "data-test-subj": "lns_colorMappingOrLegacyPalette_switch",
    compressed: true,
    checked: useNewColorMapping,
    onChange: ({
      target: {
        checked
      }
    }) => {
      (0, _lens_ui_telemetry.trackUiCounterEvents)(`color_mapping_switch_${checked ? 'enabled' : 'disabled'}`);
      setColorMapping(checked ? {
        ..._coloring.DEFAULT_COLOR_MAPPING_CONFIG
      } : undefined);
      setUseNewColorMapping(checked);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, canUseColorMapping || useNewColorMapping ? /*#__PURE__*/_react.default.createElement(_coloring.CategoricalColorMapping, {
    isDarkMode: props.isDarkMode,
    model: (_currentLayer$colorMa = currentLayer.colorMapping) !== null && _currentLayer$colorMa !== void 0 ? _currentLayer$colorMa : {
      ..._coloring.DEFAULT_COLOR_MAPPING_CONFIG
    },
    onModelUpdate: model => setColorMapping(model),
    palettes: _coloring.AVAILABLE_PALETTES,
    data: {
      type: 'categories',
      categories: splitCategories
    },
    specialTokens: _coloring.SPECIAL_TOKENS_STRING_CONVERSION
  }) : /*#__PURE__*/_react.default.createElement(_shared_components.PalettePicker, {
    palettes: props.paletteService,
    activePalette: props.state.palette,
    setPalette: newPalette => {
      setLocalState({
        ...props.state,
        palette: newPalette
      });
    }
  })))))), showColorPicker && /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.ColorPicker, (0, _extends2.default)({}, props, {
    overwriteColor: (_currentLayer$colorsB = currentLayer.colorsByDimension) === null || _currentLayer$colorsB === void 0 ? void 0 : _currentLayer$colorsB[props.accessor],
    defaultColor: (0, _visualization.getDefaultColorForMultiMetricDimension)({
      layer: currentLayer,
      columnId: props.accessor,
      paletteService: props.paletteService,
      datasource: props.datasource,
      palette: props.state.palette
    }),
    disabledMessage: colorPickerDisabledMessage,
    setConfig: setConfig
  })));
}
function DimensionDataExtraEditor(props) {
  var _currentLayer$seconda, _currentLayer$collaps;
  const currentLayer = props.state.layers.find(layer => layer.layerId === props.layerId);
  if (!currentLayer) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, [...currentLayer.primaryGroups, ...((_currentLayer$seconda = currentLayer.secondaryGroups) !== null && _currentLayer$seconda !== void 0 ? _currentLayer$seconda : [])].includes(props.accessor) && /*#__PURE__*/_react.default.createElement(_collapse_setting.CollapseSetting, {
    value: (currentLayer === null || currentLayer === void 0 ? void 0 : (_currentLayer$collaps = currentLayer.collapseFns) === null || _currentLayer$collaps === void 0 ? void 0 : _currentLayer$collaps[props.accessor]) || '',
    onChange: collapseFn => {
      props.setState({
        ...props.state,
        layers: props.state.layers.map(layer => layer.layerId !== props.layerId ? layer : {
          ...layer,
          collapseFns: {
            ...layer.collapseFns,
            [props.accessor]: collapseFn
          }
        })
      });
    }
  }));
}