"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeatmapDimensionEditor = HeatmapDimensionEditor;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _coloring = require("@kbn/coloring");
var _shared_components = require("../../shared_components");
require("./dimension_editor.scss");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeatmapDimensionEditor(props) {
  var _frame$activeData;
  const {
    state,
    setState,
    frame,
    accessor,
    isInlineEditing
  } = props;
  if ((state === null || state === void 0 ? void 0 : state.valueAccessor) !== accessor) return null;
  const currentData = (_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : _frame$activeData[state.layerId];

  // need to tell the helper that the colorStops are required to display
  const {
    displayStops,
    activePalette,
    currentMinMax
  } = (0, _utils.getSafePaletteParams)(props.paletteService, currentData, accessor, state !== null && state !== void 0 && state.palette && state.palette.accessor === accessor ? state.palette : undefined);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    className: "lnsDynamicColoringRow",
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.paletteHeatmapGradient.label', {
      defaultMessage: 'Color'
    })
  }, /*#__PURE__*/_react.default.createElement(_shared_components.PalettePanelContainer, {
    palette: displayStops.map(({
      color
    }) => color),
    siblingRef: props.panelRef,
    isInlineEditing: isInlineEditing
  }, activePalette && /*#__PURE__*/_react.default.createElement(_coloring.CustomizablePalette, {
    palettes: props.paletteService,
    activePalette: activePalette,
    dataBounds: currentMinMax,
    setPalette: newPalette => {
      // make sure to always have a list of stops
      if (newPalette.params && !newPalette.params.stops) {
        newPalette.params.stops = displayStops;
      }
      newPalette.accessor = accessor;
      setState({
        ...state,
        palette: newPalette
      });
    }
  }))));
}