"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableDimensionEditorAdditionalSection = TableDimensionEditorAdditionalSection;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _visualizationUtils = require("@kbn/visualization-utils");
var _summary = require("../../../../common/expressions/datatable/summary");
var _utils = require("../../../../common/expressions/datatable/utils");
require("./dimension_editor.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function updateColumnWith(state, columnId, newColumnProps) {
  return state.columns.map(currentColumn => {
    if (currentColumn.columnId === columnId) {
      return {
        ...currentColumn,
        ...newColumnProps
      };
    } else {
      return currentColumn;
    }
  });
}
function TableDimensionEditorAdditionalSection(props) {
  var _frame$activeData;
  const {
    state,
    setState,
    frame,
    accessor
  } = props;
  const column = state.columns.find(({
    columnId
  }) => accessor === columnId);
  const onSummaryLabelChangeToDebounce = (0, _react.useCallback)(newSummaryLabel => {
    setState({
      ...state,
      columns: updateColumnWith(state, accessor, {
        summaryLabel: newSummaryLabel
      })
    });
  }, [accessor, setState, state]);
  const {
    inputValue: summaryLabel,
    handleInputChange: onSummaryLabelChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    onChange: onSummaryLabelChangeToDebounce,
    value: column === null || column === void 0 ? void 0 : column.summaryLabel
  }, {
    allowFalsyValue: true
  } // falsy values are valid for this feature
  );
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!column) return null;
  if (column.isTransposed) return null;
  const currentData = (_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : _frame$activeData[state.layerId];
  const isNumeric = (0, _utils.isNumericFieldForDatatable)(currentData, accessor);
  // when switching from one operation to another, make sure to keep the configuration consistent
  const {
    summaryRow,
    summaryLabel: fallbackSummaryLabel
  } = (0, _summary.getFinalSummaryConfiguration)(accessor, column, currentData);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isNumeric && /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsIndexPatternDimensionEditor--padded lnsIndexPatternDimensionEditor--collapseNext"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
              margin-bottom: ${euiTheme.size.base};
            `
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.lens.indexPattern.dimensionEditor.headingSummary', {
    defaultMessage: 'Summary'
  }))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.table.summaryRow.label', {
      defaultMessage: 'Summary Row'
    }),
    display: "columnCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    isClearable: false,
    "data-test-subj": "lnsDatatable_summaryrow_function",
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.fieldPlaceholder', {
      defaultMessage: 'Field'
    }),
    options: (0, _summary.getSummaryRowOptions)(),
    selectedOptions: [{
      label: (0, _summary.getDefaultSummaryLabel)(summaryRow),
      value: summaryRow
    }],
    singleSelection: {
      asPlainText: true
    },
    onChange: choices => {
      const newValue = choices[0].value;
      setState({
        ...state,
        columns: updateColumnWith(state, accessor, {
          summaryRow: newValue
        })
      });
    }
  })), summaryRow !== 'none' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.table.summaryRow.customlabel', {
      defaultMessage: 'Summary label'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    compressed: true,
    "data-test-subj": "lnsDatatable_summaryrow_label",
    value: summaryLabel !== null && summaryLabel !== void 0 ? summaryLabel : fallbackSummaryLabel,
    onChange: e => {
      onSummaryLabelChange(e.target.value);
    }
  })))));
}