"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingWithSiblingFlyout = SettingWithSiblingFlyout;
require("./setting_with_sibling_flyout.scss");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TITLE = _i18n.i18n.translate('xpack.lens.colorSiblingFlyoutTitle', {
  defaultMessage: 'Color'
});
function SettingWithSiblingFlyout({
  siblingRef,
  children,
  title = DEFAULT_TITLE,
  isInlineEditing,
  SettingTrigger,
  dataTestSubj = 'lns-settingWithSiblingFlyout'
}) {
  const [focusTrapIsEnabled, setFocusTrapIsEnabled] = (0, _react.useState)(false);
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  const toggleFlyout = () => {
    setIsFlyoutOpen(!isFlyoutOpen);
  };
  const closeFlyout = () => {
    setIsFlyoutOpen(false);
    setFocusTrapIsEnabled(false);
  };
  (0, _react.useEffect)(() => {
    // The EuiFocusTrap is disabled when inline editing as it causes bugs with comboboxes
    if (isFlyoutOpen && !isInlineEditing) {
      // without setTimeout here the flyout pushes content when animating
      setTimeout(() => {
        setFocusTrapIsEnabled(true);
      }, 255);
    }
  }, [isInlineEditing, isFlyoutOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(SettingTrigger, {
    onClick: toggleFlyout
  }), isFlyoutOpen && siblingRef.current && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    insert: {
      sibling: siblingRef.current,
      position: 'after'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    disabled: !focusTrapIsEnabled,
    clickOutsideDisables: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: closeFlyout,
    isDisabled: !isFlyoutOpen
  }, /*#__PURE__*/_react.default.createElement("div", {
    role: "dialog",
    "aria-labelledby": "lnsSettingWithSiblingFlyoutTitle",
    "data-test-subj": dataTestSubj,
    className: "lnsSettingWithSiblingFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    className: "lnsSettingWithSiblingFlyout__header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    "data-test-subj": "lns-indexPattern-SettingWithSiblingFlyoutBack",
    className: "lnsSettingWithSiblingFlyout__backIcon",
    onClick: closeFlyout,
    iconType: "sortLeft",
    "aria-label": _i18n.i18n.translate('xpack.lens.settingWithSiblingFlyout.back', {
      defaultMessage: 'Back'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "lnsSettingWithSiblingFlyoutTitle",
    className: "lnsSettingWithSiblingFlyout__headerTitle"
  }, title))))), children && /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsSettingWithSiblingFlyout__content"
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    className: "lnsSettingWithSiblingFlyout__footer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    iconType: "sortLeft",
    onClick: closeFlyout
  }, _i18n.i18n.translate('xpack.lens.settingWithSiblingFlyout.back', {
    defaultMessage: 'Back'
  }))))))));
}