"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEIGHTS = exports.ToolbarButton = exports.TOOLBAR_BUTTON_SIZES = exports.POSITIONS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./toolbar_button.scss");
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const groupPositionToClassMap = {
  none: null,
  left: 'kbnToolbarButton--groupLeft',
  center: 'kbnToolbarButton--groupCenter',
  right: 'kbnToolbarButton--groupRight'
};
const POSITIONS = exports.POSITIONS = Object.keys(groupPositionToClassMap);
const WEIGHTS = exports.WEIGHTS = ['normal', 'bold'];
const TOOLBAR_BUTTON_SIZES = exports.TOOLBAR_BUTTON_SIZES = ['s', 'm'];
const ToolbarButton = ({
  children,
  className,
  fontWeight = 'normal',
  size = 'm',
  hasArrow = true,
  groupPosition = 'none',
  dataTestSubj = '',
  textProps,
  ...rest
}) => {
  const classes = (0, _classnames.default)('kbnToolbarButton', groupPositionToClassMap[groupPosition], [`kbnToolbarButton--${fontWeight}`, `kbnToolbarButton--${size}`], className);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": dataTestSubj,
    className: classes,
    iconSide: "right",
    iconType: hasArrow ? 'arrowDown' : '',
    color: "text",
    contentProps: {
      className: 'kbnToolbarButton__content'
    },
    textProps: {
      ...textProps,
      className: (0, _classnames.default)('kbnToolbarButton__text', textProps && textProps.className)
    }
  }, rest, {
    size: size
  }), children);
};
exports.ToolbarButton = ToolbarButton;