"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColorAccessorFn = getColorAccessorFn;
var _coloring = require("@kbn/coloring");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Return a color accessor function for XY charts depending on the split accessors received.
 */
function getColorAccessorFn(colorMapping, data, isDarkMode) {
  const getColor = (0, _coloring.getColorFactory)(JSON.parse(colorMapping), (0, _coloring.getPalette)(_coloring.AVAILABLE_PALETTES, _coloring.NeutralPalette), isDarkMode, data);
  return value => {
    if (value === undefined || value === null) return null;
    return getColor(String(value));
  };
}