"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AxisBoundsControl = AxisBoundsControl;
exports.LOWER_BOUND_MAX = exports.LOG_LOWER_BOUND_MAX = void 0;
exports.getBounds = getBounds;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _range_input_field = require("../../range_input_field");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_LOWER_BOUND_MAX = exports.LOG_LOWER_BOUND_MAX = 0.01;
const LOWER_BOUND_MAX = exports.LOWER_BOUND_MAX = 0;
const idPrefix = (0, _eui.htmlIdGenerator)()();
function AxisBoundsControl({
  type,
  canHaveNiceValues,
  ...props
}) {
  var _extent$lowerBound, _extent$upperBound;
  const {
    extent,
    hasBarOrArea,
    setExtent,
    dataBounds,
    testSubjPrefix,
    scaleType,
    disableCustomRange
  } = props;
  const {
    errorMsg,
    helpMsg
  } = (0, _helpers.validateExtent)(hasBarOrArea, extent, scaleType);
  const allowedModeForNiceDomain = type === 'metric' ? ['full', 'custom'] : ['dataBounds', 'custom'];
  const canShowNiceValues = canHaveNiceValues && allowedModeForNiceDomain.includes(extent.mode);
  const canShowCustomRanges = (extent === null || extent === void 0 ? void 0 : extent.mode) === 'custom' && (type === 'bucket' || !disableCustomRange);
  const ModeAxisBoundsControl = type === 'metric' ? MetricAxisBoundsControl : BucketAxisBoundsControl;
  return /*#__PURE__*/_react.default.createElement(ModeAxisBoundsControl, (0, _extends2.default)({}, props, {
    scaleType: scaleType // only applies to MetricAxisBoundsControl
  }), canShowCustomRanges ? /*#__PURE__*/_react.default.createElement(_range_input_field.RangeInputField, {
    isInvalid: Boolean(errorMsg),
    label: ' ',
    helpText: helpMsg,
    error: errorMsg,
    testSubjLayout: `${testSubjPrefix}_axisExtent_customBounds`,
    testSubjLower: `${testSubjPrefix}_axisExtent_lowerBound`,
    testSubjUpper: `${testSubjPrefix}_axisExtent_upperBound`,
    lowerValue: (_extent$lowerBound = extent.lowerBound) !== null && _extent$lowerBound !== void 0 ? _extent$lowerBound : '',
    onLowerValueChange: e => {
      const val = Number(e.target.value);
      const isEmptyValue = e.target.value === '' || Number.isNaN(Number(val));
      setExtent({
        ...extent,
        lowerBound: isEmptyValue ? undefined : val
      });
    },
    onLowerValueBlur: () => {
      if (extent.lowerBound === undefined && dataBounds) {
        setExtent({
          ...extent,
          lowerBound: getBounds('custom', scaleType, dataBounds).lowerBound
        });
      }
    },
    upperValue: (_extent$upperBound = extent.upperBound) !== null && _extent$upperBound !== void 0 ? _extent$upperBound : '',
    onUpperValueChange: e => {
      const val = Number(e.target.value);
      const isEmptyValue = e.target.value === '' || Number.isNaN(Number(val));
      setExtent({
        ...extent,
        upperBound: isEmptyValue ? undefined : val
      });
    },
    onUpperValueBlur: () => {
      if (extent.upperBound === undefined && dataBounds) {
        setExtent({
          ...extent,
          upperBound: dataBounds.max
        });
      }
    }
  }) : null, canShowNiceValues ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.fullExtent.niceValues', {
      defaultMessage: 'Round to nice values'
    }),
    display: "columnCompressedSwitch",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    showLabel: false,
    label: _i18n.i18n.translate('xpack.lens.fullExtent.niceValues', {
      defaultMessage: 'Round to nice values'
    }),
    "data-test-subj": `${testSubjPrefix}_axisExtent_niceValues`,
    checked: extent.niceValues == null || extent.niceValues,
    onChange: ({
      target: {
        checked: niceValues
      }
    }) => {
      setExtent({
        ...extent,
        niceValues
      });
    }
  })) : null);
}
function MetricAxisBoundsControl({
  extent,
  setExtent,
  dataBounds,
  hasBarOrArea,
  disableCustomRange,
  testSubjPrefix,
  children,
  scaleType
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.axisExtent.label', {
      defaultMessage: 'Bounds'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.axisExtent.label', {
      defaultMessage: 'Bounds'
    }),
    "data-test-subj": `${testSubjPrefix}_axisBounds_groups`,
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}full`,
      label: _i18n.i18n.translate('xpack.lens.axisExtent.full', {
        defaultMessage: 'Full'
      }),
      'data-test-subj': `${testSubjPrefix}_axisExtent_groups_full`
    }, {
      id: `${idPrefix}dataBounds`,
      label: _i18n.i18n.translate('xpack.lens.axisExtent.axisExtent.dataBounds', {
        defaultMessage: 'Data'
      }),
      'data-test-subj': `${testSubjPrefix}_axisExtent_groups_data`,
      isDisabled: hasBarOrArea,
      toolTipContent: hasBarOrArea ? _i18n.i18n.translate('xpack.lens.axisExtent.disabledDataBoundsMessage', {
        defaultMessage: 'Only line charts can be fit to the data bounds'
      }) : undefined
    }, {
      id: `${idPrefix}custom`,
      label: _i18n.i18n.translate('xpack.lens.axisExtent.axisExtent.custom', {
        defaultMessage: 'Custom'
      }),
      'data-test-subj': `${testSubjPrefix}_axisExtent_groups_custom`,
      isDisabled: disableCustomRange
    }],
    idSelected: `${idPrefix}${hasBarOrArea && extent.mode === 'dataBounds' || disableCustomRange ? 'full' : extent.mode}`,
    onChange: id => {
      const newMode = id.replace(idPrefix, '');
      setExtent({
        ...extent,
        mode: newMode,
        ...getBounds(newMode, scaleType, dataBounds)
      });
    }
  })), children);
}
function getBounds(mode, scaleType, dataBounds) {
  if (mode !== 'custom' || !dataBounds) return {
    lowerBound: undefined,
    upperBound: undefined
  };
  if (dataBounds.min >= 0 && dataBounds.max >= 0) {
    const lowerBoundMax = scaleType === 'log' ? LOG_LOWER_BOUND_MAX : LOWER_BOUND_MAX;
    return {
      upperBound: dataBounds.max,
      lowerBound: Math.max(Math.min(lowerBoundMax, dataBounds.min), lowerBoundMax)
    };
  }
  if (dataBounds.min <= 0 && dataBounds.max <= 0) {
    const upperBoundMin = scaleType === 'log' ? -LOG_LOWER_BOUND_MAX : LOWER_BOUND_MAX;
    return {
      upperBound: Math.min(Math.max(upperBoundMin, dataBounds.max), upperBoundMin),
      lowerBound: dataBounds.min
    };
  }
  if (scaleType === 'log') {
    if (Math.abs(dataBounds.min) > Math.abs(dataBounds.max)) {
      return {
        upperBound: -LOG_LOWER_BOUND_MAX,
        lowerBound: dataBounds.min
      };
    }
    return {
      upperBound: dataBounds.max,
      lowerBound: LOG_LOWER_BOUND_MAX
    };
  }
  return {
    upperBound: dataBounds.max,
    lowerBound: dataBounds.min
  };
}
function BucketAxisBoundsControl({
  extent,
  setExtent,
  dataBounds,
  testSubjPrefix,
  children
}) {
  var _extent$mode;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.axisExtent.label', {
      defaultMessage: 'Bounds'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.axisExtent.label', {
      defaultMessage: 'Bounds'
    }),
    "data-test-subj": `${testSubjPrefix}_axisBounds_groups`,
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}dataBounds`,
      label: _i18n.i18n.translate('xpack.lens.axisExtent.dataBounds', {
        defaultMessage: 'Data'
      }),
      'data-test-subj': `${testSubjPrefix}_axisExtent_groups_data`
    }, {
      id: `${idPrefix}custom`,
      label: _i18n.i18n.translate('xpack.lens.axisExtent.custom', {
        defaultMessage: 'Custom'
      }),
      'data-test-subj': `${testSubjPrefix}_axisExtent_groups_custom`
    }],
    idSelected: `${idPrefix}${(_extent$mode = extent.mode) !== null && _extent$mode !== void 0 ? _extent$mode : 'dataBounds'}`,
    onChange: id => {
      const newMode = id.replace(idPrefix, '');
      setExtent({
        ...extent,
        mode: newMode,
        lowerBound: newMode === 'custom' && dataBounds ? dataBounds.min : undefined,
        upperBound: newMode === 'custom' && dataBounds ? dataBounds.max : undefined
      });
    }
  })), children);
}