"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _public3 = require("@kbn/visualizations-plugin/public");
var _public4 = require("@kbn/ui-actions-plugin/public");
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _vis_type_alias = require("./vis_type_alias");
var _open_in_discover_action = require("./trigger_actions/open_in_discover_action");
var _edit_action = require("./trigger_actions/open_lens_config/edit_action");
var _create_action = require("./trigger_actions/open_lens_config/create_action");
var _in_app_embeddable_edit_trigger = require("./trigger_actions/open_lens_config/in_app_embeddable_edit/in_app_embeddable_edit_trigger");
var _in_app_embeddable_edit_action = require("./trigger_actions/open_lens_config/in_app_embeddable_edit/in_app_embeddable_edit_action");
var _visualize_field_actions = require("./trigger_actions/visualize_field_actions");
var _visualize_tsvb_actions = require("./trigger_actions/visualize_tsvb_actions");
var _visualize_agg_based_vis_actions = require("./trigger_actions/visualize_agg_based_vis_actions");
var _dashboard_visualize_panel_actions = require("./trigger_actions/dashboard_visualize_panel_actions");
var _embeddable_factory = require("./embeddable/embeddable_factory");
var _embeddable_component = require("./embeddable/embeddable_component");
var _saved_modal_lazy = require("./app_plugin/shared/saved_modal_lazy");
var _expressions = require("./expressions");
var _search_provider = require("./search_provider");
var _open_in_discover_drilldown = require("./trigger_actions/open_in_discover_drilldown");
var _locator = require("../common/locator/locator");
var _csv_download_provider = require("./app_plugin/csv_download_provider/csv_download_provider");
var _content_management = require("../common/content_management");
var _lens_attribute_service = require("./lens_attribute_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class LensPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "datatableVisualization", void 0);
    (0, _defineProperty2.default)(this, "editorFrameService", void 0);
    (0, _defineProperty2.default)(this, "editorFrameSetup", void 0);
    (0, _defineProperty2.default)(this, "queuedVisualizations", []);
    (0, _defineProperty2.default)(this, "FormBasedDatasource", void 0);
    (0, _defineProperty2.default)(this, "TextBasedDatasource", void 0);
    (0, _defineProperty2.default)(this, "xyVisualization", void 0);
    (0, _defineProperty2.default)(this, "legacyMetricVisualization", void 0);
    (0, _defineProperty2.default)(this, "metricVisualization", void 0);
    (0, _defineProperty2.default)(this, "pieVisualization", void 0);
    (0, _defineProperty2.default)(this, "heatmapVisualization", void 0);
    (0, _defineProperty2.default)(this, "gaugeVisualization", void 0);
    (0, _defineProperty2.default)(this, "tagcloudVisualization", void 0);
    (0, _defineProperty2.default)(this, "topNavMenuEntries", []);
    (0, _defineProperty2.default)(this, "hasDiscoverAccess", false);
    (0, _defineProperty2.default)(this, "dataViewsService", void 0);
    (0, _defineProperty2.default)(this, "initDependenciesForApi", () => {});
    (0, _defineProperty2.default)(this, "locator", void 0);
  }
  setup(core, {
    urlForwarding,
    expressions,
    data,
    fieldFormats,
    embeddable,
    visualizations,
    charts,
    globalSearch,
    usageCollection,
    uiActionsEnhanced,
    share,
    contentManagement
  }) {
    const startServices = (0, _public.createStartServicesGetter)(core.getStartServices);
    const getStartServicesForEmbeddable = async () => {
      const {
        getLensAttributeService,
        setUsageCollectionStart,
        initMemoizedErrorNotification
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
      const {
        core: coreStart,
        plugins
      } = startServices();
      await this.initParts(core, data, charts, expressions, fieldFormats, plugins.fieldFormats.deserialize);
      const [visualizationMap, datasourceMap] = await Promise.all([this.editorFrameService.loadVisualizations(), this.editorFrameService.loadDatasources()]);
      const {
        setVisualizationMap,
        setDatasourceMap
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
      setDatasourceMap(datasourceMap);
      setVisualizationMap(visualizationMap);
      const eventAnnotationService = await plugins.eventAnnotation.getService();
      if (plugins.usageCollection) {
        setUsageCollectionStart(plugins.usageCollection);
      }
      initMemoizedErrorNotification(coreStart);
      return {
        attributeService: getLensAttributeService(coreStart, plugins),
        capabilities: coreStart.application.capabilities,
        coreHttp: coreStart.http,
        coreStart,
        data: plugins.data,
        timefilter: plugins.data.query.timefilter.timefilter,
        expressionRenderer: plugins.expressions.ReactExpressionRenderer,
        documentToExpression: doc => this.editorFrameService.documentToExpression(doc, {
          dataViews: plugins.dataViews,
          storage: new _public.Storage(localStorage),
          uiSettings: core.uiSettings,
          timefilter: plugins.data.query.timefilter.timefilter,
          nowProvider: plugins.data.nowProvider,
          eventAnnotationService
        }),
        injectFilterReferences: data.query.filterManager.inject.bind(data.query.filterManager),
        visualizationMap,
        datasourceMap,
        dataViews: plugins.dataViews,
        uiActions: plugins.uiActions,
        usageCollection,
        inspector: plugins.inspector,
        spaces: plugins.spaces,
        theme: core.theme,
        uiSettings: core.uiSettings
      };
    };
    if (embeddable) {
      embeddable.registerEmbeddableFactory('lens', new _embeddable_factory.EmbeddableFactory(getStartServicesForEmbeddable));
      embeddable.registerSavedObjectToPanelMethod(_content_management.CONTENT_ID, savedObject => {
        if (!savedObject.managed) {
          return {
            savedObjectId: savedObject.id
          };
        }
        const panel = {
          attributes: (0, _lens_attribute_service.savedObjectToEmbeddableAttributes)(savedObject)
        };
        return panel;
      });
    }
    if (share) {
      this.locator = share.url.locators.create(new _locator.LensAppLocatorDefinition());
      share.register((0, _csv_download_provider.downloadCsvShareProvider)({
        uiSettings: core.uiSettings,
        formatFactoryFn: () => startServices().plugins.fieldFormats.deserialize,
        atLeastGold: () => {
          var _startServices$plugin;
          let isGold = false;
          (_startServices$plugin = startServices().plugins.licensing) === null || _startServices$plugin === void 0 ? void 0 : _startServices$plugin.license$.pipe().subscribe(license => {
            isGold = license.hasAtLeast('gold');
          });
          return isGold;
        }
      }));
    }
    visualizations.registerAlias((0, _vis_type_alias.getLensAliasConfig)());
    uiActionsEnhanced.registerDrilldown(new _open_in_discover_drilldown.OpenInDiscoverDrilldown({
      dataViews: () => this.dataViewsService,
      locator: () => share === null || share === void 0 ? void 0 : share.url.locators.get('DISCOVER_APP_LOCATOR'),
      hasDiscoverAccess: () => this.hasDiscoverAccess,
      application: () => startServices().core.application
    }));
    contentManagement.registry.register({
      id: _content_management.CONTENT_ID,
      version: {
        latest: _content_management.LATEST_VERSION
      },
      name: _i18n.i18n.translate('xpack.lens.content.name', {
        defaultMessage: 'Lens Visualization'
      })
    });
    (0, _expressions.setupExpressions)(expressions, () => startServices().plugins.fieldFormats.deserialize, () => startServices().plugins.data.datatableUtilities, async () => {
      const {
        getTimeZone
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./utils')));
      return getTimeZone(core.uiSettings);
    }, () => startServices().plugins.data.nowProvider.get());
    core.application.register({
      id: _constants.APP_ID,
      title: _constants.NOT_INTERNATIONALIZED_PRODUCT_NAME,
      visibleIn: [],
      mount: async params => {
        const {
          core: coreStart,
          plugins: deps
        } = startServices();
        await this.initParts(core, data, charts, expressions, fieldFormats, deps.fieldFormats.deserialize);
        const {
          mountApp,
          getLensAttributeService,
          setUsageCollectionStart,
          initMemoizedErrorNotification
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
        if (deps.usageCollection) {
          setUsageCollectionStart(deps.usageCollection);
        }
        initMemoizedErrorNotification(coreStart);
        const frameStart = this.editorFrameService.start(coreStart, deps);
        return mountApp(core, params, {
          createEditorFrame: frameStart.createInstance,
          attributeService: getLensAttributeService(coreStart, deps),
          topNavMenuEntryGenerators: this.topNavMenuEntries,
          locator: this.locator
        });
      }
    });
    if (globalSearch) {
      globalSearch.registerResultProvider((0, _search_provider.getSearchProvider)(core.getStartServices().then(([{
        application: {
          capabilities
        }
      }]) => capabilities)));
    }
    urlForwarding.forwardApp('lens', 'lens');
    this.initDependenciesForApi = async () => {
      const {
        plugins
      } = startServices();
      await this.initParts(core, data, charts, expressions, fieldFormats, plugins.fieldFormats.deserialize);
    };
    return {
      registerVisualization: vis => {
        if (this.editorFrameSetup) {
          this.editorFrameSetup.registerVisualization(vis);
        } else {
          // queue visualizations if editor frame is not yet ready as it's loaded async
          this.queuedVisualizations.push(vis);
        }
      },
      registerTopNavMenuEntryGenerator: menuEntryGenerator => {
        this.topNavMenuEntries.push(menuEntryGenerator);
      }
    };
  }
  async initParts(core, data, charts, expressions, fieldFormats, formatFactory) {
    const {
      DatatableVisualization,
      EditorFrameService,
      FormBasedDatasource,
      XyVisualization,
      LegacyMetricVisualization,
      MetricVisualization,
      PieVisualization,
      HeatmapVisualization,
      GaugeVisualization,
      TagcloudVisualization,
      TextBasedDatasource
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
    this.datatableVisualization = new DatatableVisualization();
    this.editorFrameService = new EditorFrameService();
    this.FormBasedDatasource = new FormBasedDatasource();
    this.TextBasedDatasource = new TextBasedDatasource();
    this.xyVisualization = new XyVisualization();
    this.legacyMetricVisualization = new LegacyMetricVisualization();
    this.metricVisualization = new MetricVisualization();
    this.pieVisualization = new PieVisualization();
    this.heatmapVisualization = new HeatmapVisualization();
    this.gaugeVisualization = new GaugeVisualization();
    this.tagcloudVisualization = new TagcloudVisualization();
    const editorFrameSetupInterface = this.editorFrameService.setup();
    const dependencies = {
      expressions,
      data,
      fieldFormats,
      charts,
      editorFrame: editorFrameSetupInterface,
      formatFactory
    };
    this.FormBasedDatasource.setup(core, dependencies);
    this.TextBasedDatasource.setup(core, dependencies);
    this.xyVisualization.setup(core, dependencies);
    this.datatableVisualization.setup(core, dependencies);
    this.legacyMetricVisualization.setup(core, dependencies);
    this.metricVisualization.setup(core, dependencies);
    this.pieVisualization.setup(core, dependencies);
    this.heatmapVisualization.setup(core, dependencies);
    this.gaugeVisualization.setup(core, dependencies);
    this.tagcloudVisualization.setup(core, dependencies);
    this.queuedVisualizations.forEach(queuedVis => {
      editorFrameSetupInterface.registerVisualization(queuedVis);
    });
    this.editorFrameSetup = editorFrameSetupInterface;
  }
  start(core, startDependencies) {
    var _startDependencies$sh;
    this.hasDiscoverAccess = core.application.capabilities.discover.show;
    this.dataViewsService = startDependencies.dataViews;
    // unregisters the Visualize action and registers the lens one
    if (startDependencies.uiActions.hasAction(_public4.ACTION_VISUALIZE_FIELD)) {
      startDependencies.uiActions.unregisterAction(_public4.ACTION_VISUALIZE_FIELD);
    }

    // this trigger enables external consumers to use the inline editing flyout
    startDependencies.uiActions.registerTrigger(_in_app_embeddable_edit_trigger.inAppEmbeddableEditTrigger);
    startDependencies.uiActions.addTriggerAction(_public4.VISUALIZE_FIELD_TRIGGER, (0, _visualize_field_actions.visualizeFieldAction)(core.application));
    startDependencies.uiActions.addTriggerAction(_public3.VISUALIZE_EDITOR_TRIGGER, (0, _visualize_tsvb_actions.visualizeTSVBAction)(core.application));
    startDependencies.uiActions.addTriggerAction(_public3.DASHBOARD_VISUALIZATION_PANEL_TRIGGER, (0, _dashboard_visualize_panel_actions.visualizeDashboardVisualizePanelction)(core.application));
    startDependencies.uiActions.addTriggerAction(_public3.AGG_BASED_VISUALIZATION_TRIGGER, (0, _visualize_agg_based_vis_actions.visualizeAggBasedVisAction)(core.application));
    const editInLensAction = new _edit_action.ConfigureInLensPanelAction(startDependencies, core);
    // dashboard edit panel action
    startDependencies.uiActions.addTriggerAction('CONTEXT_MENU_TRIGGER', editInLensAction);

    // Allows the Lens embeddable to easily open the inapp editing flyout
    const editLensEmbeddableAction = new _in_app_embeddable_edit_action.EditLensEmbeddableAction(startDependencies, core);
    // embeddable edit panel action
    startDependencies.uiActions.addTriggerAction(_in_app_embeddable_edit_trigger.IN_APP_EMBEDDABLE_EDIT_TRIGGER, editLensEmbeddableAction);

    // Displays the add ESQL panel in the dashboard add Panel menu
    const createESQLPanelAction = new _create_action.CreateESQLPanelAction(startDependencies, core, async () => {
      if (!this.editorFrameService) {
        await this.initDependenciesForApi();
      }
      return this.editorFrameService;
    });
    startDependencies.uiActions.addTriggerAction(_public4.ADD_PANEL_TRIGGER, createESQLPanelAction);
    const discoverLocator = (_startDependencies$sh = startDependencies.share) === null || _startDependencies$sh === void 0 ? void 0 : _startDependencies$sh.url.locators.get('DISCOVER_APP_LOCATOR');
    if (discoverLocator) {
      startDependencies.uiActions.addTriggerAction(_public2.CONTEXT_MENU_TRIGGER, (0, _open_in_discover_action.createOpenInDiscoverAction)(discoverLocator, startDependencies.dataViews, this.hasDiscoverAccess));
    }
    return {
      EmbeddableComponent: (0, _embeddable_component.getEmbeddableComponent)(core, startDependencies),
      SaveModalComponent: (0, _saved_modal_lazy.getSaveModalComponent)(core, startDependencies),
      navigateToPrefilledEditor: (input, {
        openInNewTab = false,
        originatingApp = '',
        originatingPath,
        skipAppLeave = false
      } = {}) => {
        // for openInNewTab, we set the time range in url via getEditPath below
        if (input !== null && input !== void 0 && input.timeRange && !openInNewTab) {
          startDependencies.data.query.timefilter.timefilter.setTime(input.timeRange);
        }
        const transfer = new _public2.EmbeddableStateTransfer(core.application.navigateToApp, core.application.currentAppId$);
        transfer.navigateToEditor(_constants.APP_ID, {
          openInNewTab,
          path: (0, _constants.getEditPath)(undefined, openInNewTab && (input === null || input === void 0 ? void 0 : input.timeRange) || undefined),
          state: {
            originatingApp,
            originatingPath,
            valueInput: input
          },
          skipAppLeave
        });
      },
      canUseEditor: () => {
        var _core$application$cap;
        return Boolean((_core$application$cap = core.application.capabilities.visualize) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.show);
      },
      getXyVisTypes: async () => {
        const {
          visualizationSubtypes
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./visualizations/xy/types')));
        return visualizationSubtypes;
      },
      stateHelperApi: async () => {
        const {
          createFormulaPublicApi,
          createChartInfoApi,
          suggestionsApi
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
        if (!this.editorFrameService) {
          await this.initDependenciesForApi();
        }
        const [visualizationMap, datasourceMap] = await Promise.all([this.editorFrameService.loadVisualizations(), this.editorFrameService.loadDatasources()]);
        return {
          formula: createFormulaPublicApi(),
          chartInfo: createChartInfoApi(startDependencies.dataViews, this.editorFrameService),
          suggestions: (context, dataView, excludedVisualizations, preferredChartType) => {
            return suggestionsApi({
              datasourceMap,
              visualizationMap,
              context,
              dataView,
              excludedVisualizations,
              preferredChartType
            });
          }
        };
      },
      EditLensConfigPanelApi: async () => {
        const {
          getEditLensConfiguration
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
        if (!this.editorFrameService) {
          this.initDependenciesForApi();
        }
        const [visualizationMap, datasourceMap] = await Promise.all([this.editorFrameService.loadVisualizations(), this.editorFrameService.loadDatasources()]);
        const Component = await getEditLensConfiguration(core, startDependencies, visualizationMap, datasourceMap);
        return Component;
      }
    };
  }
  stop() {}
}
exports.LensPlugin = LensPlugin;