"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggestionsApi = exports.ChartType = void 0;
var _suggestion_helpers = require("./editor_frame_service/editor_frame/suggestion_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ChartType = exports.ChartType = /*#__PURE__*/function (ChartType) {
  ChartType["XY"] = "XY";
  ChartType["Bar"] = "Bar";
  ChartType["Line"] = "Line";
  ChartType["Area"] = "Area";
  ChartType["Donut"] = "Donut";
  ChartType["Heatmap"] = "Heat map";
  ChartType["Treemap"] = "Treemap";
  ChartType["Tagcloud"] = "Tag cloud";
  ChartType["Waffle"] = "Waffle";
  ChartType["Table"] = "Table";
  return ChartType;
}({});
const suggestionsApi = ({
  context,
  dataView,
  datasourceMap,
  visualizationMap,
  excludedVisualizations,
  preferredChartType
}) => {
  const initialContext = context;
  if (!datasourceMap || !visualizationMap || !dataView.id) return undefined;
  const datasourceStates = {
    formBased: {
      isLoading: false,
      state: {
        layers: {}
      }
    },
    textBased: {
      isLoading: false,
      state: {
        layers: {},
        indexPatternRefs: [],
        initialContext
      }
    }
  };
  const currentDataViewId = dataView.id;
  const dataViews = {
    indexPatterns: {
      [currentDataViewId]: dataView
    },
    indexPatternRefs: []
  };
  const initialVisualization = (visualizationMap === null || visualizationMap === void 0 ? void 0 : visualizationMap[Object.keys(visualizationMap)[0]]) || null;

  // find the active visualizations from the context
  const suggestions = (0, _suggestion_helpers.getSuggestions)({
    datasourceMap,
    datasourceStates,
    visualizationMap,
    activeVisualization: initialVisualization,
    visualizationState: undefined,
    visualizeTriggerFieldContext: context,
    dataViews
  });
  if (!suggestions.length) return [];
  // check if there is an XY chart suggested
  // if user has requested for a line or area, we want to sligthly change the state
  // to return line / area instead of a bar chart
  const chartType = preferredChartType === null || preferredChartType === void 0 ? void 0 : preferredChartType.toLowerCase();
  const XYSuggestion = suggestions.find(sug => sug.visualizationId === 'lnsXY');
  if (XYSuggestion && chartType && ['area', 'line'].includes(chartType)) {
    var _visualizationMap$XYS, _visualizationMap$XYS2;
    const visualizationState = (_visualizationMap$XYS = visualizationMap[XYSuggestion.visualizationId]) === null || _visualizationMap$XYS === void 0 ? void 0 : (_visualizationMap$XYS2 = _visualizationMap$XYS.switchVisualizationType) === null || _visualizationMap$XYS2 === void 0 ? void 0 : _visualizationMap$XYS2.call(_visualizationMap$XYS, chartType, XYSuggestion === null || XYSuggestion === void 0 ? void 0 : XYSuggestion.visualizationState);
    return [{
      ...XYSuggestion,
      visualizationState
    }];
  }
  // in case the user asks for another type (except from area, line) check if it exists
  // in suggestions and return this instead
  if (suggestions.length > 1 && preferredChartType) {
    const suggestionFromModel = suggestions.find(s => s.title.includes(preferredChartType) || s.visualizationId.includes(preferredChartType));
    if (suggestionFromModel) {
      return [suggestionFromModel];
    }
  }
  const activeVisualization = suggestions[0];
  if (activeVisualization.incomplete || excludedVisualizations !== null && excludedVisualizations !== void 0 && excludedVisualizations.includes(activeVisualization.visualizationId)) {
    return [];
  }
  // compute the rest suggestions depending on the active one and filter out the lnsLegacyMetric
  const newSuggestions = (0, _suggestion_helpers.getSuggestions)({
    datasourceMap,
    datasourceStates: {
      textBased: {
        isLoading: false,
        state: activeVisualization.datasourceState
      }
    },
    visualizationMap,
    activeVisualization: visualizationMap[activeVisualization.visualizationId],
    visualizationState: activeVisualization.visualizationState,
    dataViews
  }).filter(sug => !sug.hide && sug.visualizationId !== 'lnsLegacyMetric');
  const suggestionsList = [activeVisualization, ...newSuggestions];

  // if there is no preference from the user, send everything
  // until we separate the text based suggestions logic from the dataview one,
  // we want to sort XY first
  const sortXYFirst = suggestionsList.sort((a, b) => a.visualizationId === 'lnsXY' ? -1 : 1);
  return sortXYFirst;
};
exports.suggestionsApi = suggestionsApi;