"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Embeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _reactDom = require("react-dom");
var _esqlUtils = require("@kbn/esql-utils");
var _ebtTools = require("@kbn/ebt-tools");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
var _rxjs = require("rxjs");
var _interpreter = require("@kbn/interpreter");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public2 = require("@kbn/visualizations-plugin/public");
var _public3 = require("@kbn/embeddable-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _presentationContainers = require("@kbn/presentation-containers");
var _report_performance_metric_util = require("../report_performance_metric_util");
var _lens_ui_telemetry = require("../lens_ui_telemetry");
var _expression_wrapper = require("./expression_wrapper");
var _types = require("../types");
var _constants = require("../../common/constants");
var _lens_inspector_service = require("../lens_inspector_service");
var _utils = require("../utils");
var _show_underlying_data = require("../app_plugin/show_underlying_data");
var _get_application_user_messages = require("../app_plugin/get_application_user_messages");
var _message_list = require("../editor_frame_service/editor_frame/workspace_panel/message_list");
var _embeddable_info_badges = require("./embeddable_info_badges");
var _utils2 = require("../state_management/utils");
var _user_messages_utils = require("../user_messages_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function VisualizationErrorPanel({
  errors,
  canEdit
}) {
  const firstError = errors.at(0);
  const canFixInLens = canEdit && errors.some(({
    fixableInEditor
  }) => fixableInEditor);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsEmbeddedError"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    iconColor: "danger",
    "data-test-subj": "embeddable-lens-failure",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, firstError ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, (0, _user_messages_utils.getLongMessage)(firstError)), errors.length > 1 && !canFixInLens ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.embeddable.moreErrors",
      defaultMessage: "Edit in Lens editor to see more errors"
    })) : null, canFixInLens ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.embeddable.fixErrors",
      defaultMessage: "Edit in Lens editor to fix the error"
    })) : null) : /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.embeddable.failure",
      defaultMessage: "Visualization couldn't be displayed"
    })))
  }));
}
const getExpressionFromDocument = async (document, documentToExpression) => {
  const {
    ast,
    indexPatterns,
    indexPatternRefs,
    activeVisualizationState
  } = await documentToExpression(document);
  return {
    ast: ast ? (0, _interpreter.toExpression)(ast) : null,
    indexPatterns,
    indexPatternRefs,
    activeVisualizationState
  };
};
function getViewUnderlyingDataArgs({
  activeDatasource,
  activeDatasourceState,
  activeVisualization,
  activeVisualizationState,
  activeData,
  dataViews,
  capabilities,
  query,
  filters,
  timeRange,
  esQueryConfig,
  indexPatternsCache
}) {
  const {
    error,
    meta
  } = (0, _show_underlying_data.getLayerMetaInfo)(activeDatasource, activeDatasourceState, activeVisualization, activeVisualizationState, activeData, indexPatternsCache, timeRange, capabilities);
  if (error || !meta) {
    return;
  }
  const luceneOrKuery = [];
  const aggregateQuery = [];
  if (Array.isArray(query)) {
    query.forEach(q => {
      if ((0, _esQuery.isOfQueryType)(q)) {
        luceneOrKuery.push(q);
      } else {
        aggregateQuery.push(q);
      }
    });
  }
  const {
    filters: newFilters,
    query: newQuery
  } = (0, _show_underlying_data.combineQueryAndFilters)(luceneOrKuery.length > 0 ? luceneOrKuery : query, filters, meta, dataViews, esQueryConfig);
  const dataViewSpec = indexPatternsCache[meta.id].spec;
  return {
    dataViewSpec,
    timeRange,
    filters: newFilters,
    query: aggregateQuery.length > 0 ? aggregateQuery[0] : newQuery,
    columns: meta.columns
  };
}
const EmbeddableMessagesPopover = ({
  messages
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  if (!messages.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_message_list.MessageList, {
    messages: messages,
    customButtonStyles: (0, _react2.css)`
        block-size: ${euiTheme.size.l};
        font-size: ${xsFontSize};
        padding: 0 ${euiTheme.size.xs};
        & > * {
          gap: ${euiTheme.size.xs};
        }
      `
  });
};
const blockingMessageDisplayLocations = ['visualization', 'visualizationOnEmbeddable'];
const MessagesBadge = ({
  onMount
}) => /*#__PURE__*/_react.default.createElement("div", {
  css: (0, _react2.css)({
    position: 'absolute',
    zIndex: 2,
    left: 0,
    bottom: 0
  }),
  ref: el => {
    if (el) {
      onMount(el);
    }
  }
});
class Embeddable extends _public3.Embeddable {
  logError(type) {
    (0, _lens_ui_telemetry.trackUiCounterEvents)(type === 'runtime' ? 'embeddable_runtime_error' : 'embeddable_validation_error', this.getExecutionContext());
  }
  constructor(deps, initialInput, parent) {
    super(initialInput, {
      editApp: 'lens'
    }, parent);
    (0, _defineProperty2.default)(this, "type", _constants.DOC_TYPE);
    (0, _defineProperty2.default)(this, "deferEmbeddableLoad", true);
    (0, _defineProperty2.default)(this, "expressionRenderer", void 0);
    (0, _defineProperty2.default)(this, "savedVis", void 0);
    (0, _defineProperty2.default)(this, "expression", void 0);
    (0, _defineProperty2.default)(this, "domNode", void 0);
    (0, _defineProperty2.default)(this, "isInitialized", false);
    (0, _defineProperty2.default)(this, "inputReloadSubscriptions", void 0);
    (0, _defineProperty2.default)(this, "isDestroyed", void 0);
    (0, _defineProperty2.default)(this, "lensInspector", void 0);
    (0, _defineProperty2.default)(this, "activeData", void 0);
    (0, _defineProperty2.default)(this, "internalDataViews", []);
    (0, _defineProperty2.default)(this, "viewUnderlyingDataArgs", void 0);
    (0, _defineProperty2.default)(this, "activeVisualizationState", void 0);
    (0, _defineProperty2.default)(this, "indexPatterns", {});
    (0, _defineProperty2.default)(this, "indexPatternRefs", []);
    (0, _defineProperty2.default)(this, "fullAttributes", void 0);
    (0, _defineProperty2.default)(this, "handleExternalUserMessage", messages => {
      if (this.input.onBeforeBadgesRender) {
        // we need something else to better identify those errors
        const [messagesToHandle, originalMessages] = (0, _lodash.partition)(messages, message => message.displayLocations.some(location => location.id === 'embeddableBadge'));
        if (messagesToHandle.length > 0) {
          const customBadgeMessages = this.input.onBeforeBadgesRender(messagesToHandle);
          return [...originalMessages, ...customBadgeMessages];
        }
      }
      return messages;
    });
    (0, _defineProperty2.default)(this, "getUserMessages", (locationId, filters) => {
      var _this$savedVis, _mergedSearchContext$, _mergedSearchContext$2, _mergedSearchContext$3, _mergedSearchContext$4, _mergedSearchContext$5, _mergedSearchContext$6, _mergedSearchContext$7, _mergedSearchContext$8, _mergedSearchContext$9, _this$activeDatasourc, _this$activeDatasourc2, _this$activeVisualiza, _this$activeVisualiza2, _this$activeVisualiza3, _this$activeVisualiza4, _this$activeVisualiza5;
      const userMessages = [];
      userMessages.push(...(0, _get_application_user_messages.getApplicationUserMessages)({
        visualizationType: (_this$savedVis = this.savedVis) === null || _this$savedVis === void 0 ? void 0 : _this$savedVis.visualizationType,
        visualizationState: {
          state: this.activeVisualizationState,
          activeId: this.activeVisualizationId
        },
        visualization: this.activeVisualizationId && this.deps.visualizationMap[this.activeVisualizationId] ? this.deps.visualizationMap[this.activeVisualizationId] : undefined,
        activeDatasource: this.activeDatasource,
        activeDatasourceState: {
          isLoading: !this.activeDatasourceState,
          state: this.activeDatasourceState
        },
        dataViews: {
          indexPatterns: this.indexPatterns,
          indexPatternRefs: this.indexPatternRefs // TODO - are these actually used?
        },
        core: this.deps.coreStart
      }));
      if (!this.savedVis) {
        return this.handleExternalUserMessage(userMessages);
      }
      const mergedSearchContext = this.getMergedSearchContext();
      const framePublicAPI = {
        dataViews: {
          indexPatterns: this.indexPatterns,
          indexPatternRefs: this.indexPatternRefs
        },
        datasourceLayers: (0, _utils2.getDatasourceLayers)({
          [this.activeDatasourceId]: {
            isLoading: !this.activeDatasourceState,
            state: this.activeDatasourceState
          }
        }, this.deps.datasourceMap, this.indexPatterns),
        query: this.savedVis.state.query,
        filters: (_mergedSearchContext$ = mergedSearchContext.filters) !== null && _mergedSearchContext$ !== void 0 ? _mergedSearchContext$ : [],
        dateRange: {
          fromDate: (_mergedSearchContext$2 = (_mergedSearchContext$3 = mergedSearchContext.timeRange) === null || _mergedSearchContext$3 === void 0 ? void 0 : _mergedSearchContext$3.from) !== null && _mergedSearchContext$2 !== void 0 ? _mergedSearchContext$2 : '',
          toDate: (_mergedSearchContext$4 = (_mergedSearchContext$5 = mergedSearchContext.timeRange) === null || _mergedSearchContext$5 === void 0 ? void 0 : _mergedSearchContext$5.to) !== null && _mergedSearchContext$4 !== void 0 ? _mergedSearchContext$4 : ''
        },
        absDateRange: {
          fromDate: (_mergedSearchContext$6 = (_mergedSearchContext$7 = mergedSearchContext.timeRange) === null || _mergedSearchContext$7 === void 0 ? void 0 : _mergedSearchContext$7.from) !== null && _mergedSearchContext$6 !== void 0 ? _mergedSearchContext$6 : '',
          toDate: (_mergedSearchContext$8 = (_mergedSearchContext$9 = mergedSearchContext.timeRange) === null || _mergedSearchContext$9 === void 0 ? void 0 : _mergedSearchContext$9.to) !== null && _mergedSearchContext$8 !== void 0 ? _mergedSearchContext$8 : ''
        },
        activeData: this.activeData
      };
      userMessages.push(...((_this$activeDatasourc = (_this$activeDatasourc2 = this.activeDatasource) === null || _this$activeDatasourc2 === void 0 ? void 0 : _this$activeDatasourc2.getUserMessages(this.activeDatasourceState, {
        setState: () => {},
        frame: framePublicAPI,
        visualizationInfo: (_this$activeVisualiza = this.activeVisualization) === null || _this$activeVisualiza === void 0 ? void 0 : (_this$activeVisualiza2 = _this$activeVisualiza.getVisualizationInfo) === null || _this$activeVisualiza2 === void 0 ? void 0 : _this$activeVisualiza2.call(_this$activeVisualiza, this.activeVisualizationState, framePublicAPI)
      })) !== null && _this$activeDatasourc !== void 0 ? _this$activeDatasourc : []), ...((_this$activeVisualiza3 = (_this$activeVisualiza4 = this.activeVisualization) === null || _this$activeVisualiza4 === void 0 ? void 0 : (_this$activeVisualiza5 = _this$activeVisualiza4.getUserMessages) === null || _this$activeVisualiza5 === void 0 ? void 0 : _this$activeVisualiza5.call(_this$activeVisualiza4, this.activeVisualizationState, {
        frame: framePublicAPI
      })) !== null && _this$activeVisualiza3 !== void 0 ? _this$activeVisualiza3 : []));
      return this.handleExternalUserMessage((0, _get_application_user_messages.filterAndSortUserMessages)([...userMessages, ...Object.values(this.additionalUserMessages)], locationId, filters !== null && filters !== void 0 ? filters : {}));
    });
    (0, _defineProperty2.default)(this, "additionalUserMessages", {});
    // used to add warnings and errors from elsewhere in the embeddable
    (0, _defineProperty2.default)(this, "addUserMessages", messages => {
      const newMessageMap = {
        ...this.additionalUserMessages
      };
      const addedMessageIds = [];
      messages.forEach(message => {
        if (!newMessageMap[message.uniqueId]) {
          addedMessageIds.push(message.uniqueId);
          newMessageMap[message.uniqueId] = message;
        }
      });
      if (addedMessageIds.length) {
        this.additionalUserMessages = newMessageMap;
        this.renderUserMessages();
      }
      return () => {
        messages.forEach(({
          uniqueId
        }) => {
          delete this.additionalUserMessages[uniqueId];
        });
      };
    });
    (0, _defineProperty2.default)(this, "removeActiveDataWarningMessages", () => {});
    (0, _defineProperty2.default)(this, "updateActiveData", (data, adapters) => {
      var _adapters$tables;
      if (this.input.onLoad) {
        // once onData$ is get's called from expression renderer, loading becomes false
        this.input.onLoad(false, adapters, this.getOutput$());
      }
      const {
        type,
        error
      } = data;
      this.updateOutput({
        loading: false,
        error: type === 'error' ? error : undefined
      });
      const newActiveData = adapters === null || adapters === void 0 ? void 0 : (_adapters$tables = adapters.tables) === null || _adapters$tables === void 0 ? void 0 : _adapters$tables.tables;
      this.removeActiveDataWarningMessages();
      const searchWarningMessages = this.getSearchWarningMessages(adapters);
      this.removeActiveDataWarningMessages = this.addUserMessages(searchWarningMessages);
      this.activeData = newActiveData;
      this.renderUserMessages();
    });
    (0, _defineProperty2.default)(this, "onRender", () => {
      var _this$savedVis2;
      let datasourceEvents = [];
      let visualizationEvents = [];
      if (this.savedVis) {
        datasourceEvents = Object.values(this.deps.datasourceMap).reduce((acc, datasource) => {
          var _datasource$getRender, _datasource$getRender2;
          return [...acc, ...((_datasource$getRender = (_datasource$getRender2 = datasource.getRenderEventCounters) === null || _datasource$getRender2 === void 0 ? void 0 : _datasource$getRender2.call(datasource, this.savedVis.state.datasourceStates[datasource.id])) !== null && _datasource$getRender !== void 0 ? _datasource$getRender : [])];
        }, []);
        if (this.savedVis.visualizationType) {
          var _this$deps$visualizat, _this$deps$visualizat2, _this$deps$visualizat3;
          visualizationEvents = (_this$deps$visualizat = (_this$deps$visualizat2 = (_this$deps$visualizat3 = this.deps.visualizationMap[this.savedVis.visualizationType]).getRenderEventCounters) === null || _this$deps$visualizat2 === void 0 ? void 0 : _this$deps$visualizat2.call(_this$deps$visualizat3, this.savedVis.state.visualization)) !== null && _this$deps$visualizat !== void 0 ? _this$deps$visualizat : [];
        }
      }
      const executionContext = this.getExecutionContext();
      const events = [...datasourceEvents, ...visualizationEvents, ...(0, _lens_ui_telemetry.getExecutionContextEvents)(executionContext)];
      const adHocDataViews = Object.values(((_this$savedVis2 = this.savedVis) === null || _this$savedVis2 === void 0 ? void 0 : _this$savedVis2.state.adHocDataViews) || {});
      adHocDataViews.forEach(() => {
        events.push('ad_hoc_data_view');
      });
      (0, _lens_ui_telemetry.trackUiCounterEvents)(events, executionContext);
      this.trackContentfulRender();
      this.renderComplete.dispatchComplete();
      this.updateOutput({
        ...this.getOutput(),
        rendered: true
      });
      const inspectorAdapters = this.getInspectorAdapters();
      const timings = (0, _report_performance_metric_util.getSuccessfulRequestTimings)(inspectorAdapters);
      if (timings) {
        const esRequestMetrics = {
          eventName: 'lens_chart_es_request_totals',
          duration: timings.requestTimeTotal,
          key1: 'es_took_total',
          value1: timings.esTookTotal
        };
        (0, _ebtTools.reportPerformanceMetricEvent)(this.deps.coreStart.analytics, esRequestMetrics);
      }
    });
    (0, _defineProperty2.default)(this, "badgeDomNode", void 0);
    /**
     * This method is called on every render, and also whenever the badges dom node is created
     * That happens after either the expression renderer or the visualization error panel is rendered.
     *
     * You should not call this method on its own. Use renderUserMessages instead.
     */
    (0, _defineProperty2.default)(this, "renderBadgeMessages", () => {
      const messages = this.getUserMessages('embeddableBadge');
      const [warningOrErrorMessages, infoMessages] = (0, _lodash.partition)(messages, ({
        severity
      }) => severity !== 'info');
      if (this.badgeDomNode) {
        (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, this.deps.coreStart, /*#__PURE__*/_react.default.createElement(EmbeddableMessagesPopover, {
          messages: warningOrErrorMessages
        }), /*#__PURE__*/_react.default.createElement(_embeddable_info_badges.EmbeddableFeatureBadge, {
          messages: infoMessages
        })), this.badgeDomNode);
      }
    });
    (0, _defineProperty2.default)(this, "hasCompatibleActions", async event => {
      if ((0, _types.isLensTableRowContextMenuClickEvent)(event) || (0, _types.isLensMultiFilterEvent)(event) || (0, _types.isLensFilterEvent)(event)) {
        const {
          getTriggerCompatibleActions
        } = this.deps;
        if (!getTriggerCompatibleActions) {
          return false;
        }
        const actions = await getTriggerCompatibleActions(_public2.VIS_EVENT_TO_TRIGGER[event.name], {
          data: event.data,
          embeddable: this
        });
        return actions.length > 0;
      }
      return false;
    });
    (0, _defineProperty2.default)(this, "getCompatibleCellValueActions", async data => {
      const {
        getTriggerCompatibleActions
      } = this.deps;
      if (getTriggerCompatibleActions) {
        const embeddable = this;
        const actions = await getTriggerCompatibleActions(_public3.CELL_VALUE_TRIGGER, {
          data,
          embeddable
        });
        return actions.sort((a, b) => {
          var _a$order, _b$order;
          return ((_a$order = a.order) !== null && _a$order !== void 0 ? _a$order : Infinity) - ((_b$order = b.order) !== null && _b$order !== void 0 ? _b$order : Infinity);
        }).map(action => ({
          id: action.id,
          type: action.type,
          iconType: action.getIconType({
            embeddable,
            data,
            trigger: _public3.cellValueTrigger
          }),
          displayName: action.getDisplayName({
            embeddable,
            data,
            trigger: _public3.cellValueTrigger
          }),
          execute: cellData => action.execute({
            embeddable,
            data: cellData,
            trigger: _public3.cellValueTrigger
          })
        }));
      }
      return [];
    });
    (0, _defineProperty2.default)(this, "handleEvent", async event => {
      var _eventHandler;
      if (!this.deps.getTrigger || this.input.disableTriggers) {
        return;
      }
      let eventHandler;
      let shouldExecuteDefaultTriggers = true;
      if ((0, _types.isLensBrushEvent)(event)) {
        eventHandler = this.input.onBrushEnd;
      } else if ((0, _types.isLensFilterEvent)(event) || (0, _types.isLensMultiFilterEvent)(event)) {
        eventHandler = this.input.onFilter;
      } else if ((0, _types.isLensTableRowContextMenuClickEvent)(event)) {
        eventHandler = this.input.onTableRowClick;
      }
      // if the embeddable is located in an app where there is the Unified search bar with the ES|QL editor, then use this query
      // otherwise use the query from the saved object
      let esqlQuery;
      if (this.isTextBasedLanguage()) {
        var _this$savedVis3;
        const query = this.deps.data.query.queryString.getQuery();
        esqlQuery = (0, _esQuery.isOfAggregateQueryType)(query) ? query : (_this$savedVis3 = this.savedVis) === null || _this$savedVis3 === void 0 ? void 0 : _this$savedVis3.state.query;
      }
      (_eventHandler = eventHandler) === null || _eventHandler === void 0 ? void 0 : _eventHandler({
        ...event.data,
        preventDefault: () => {
          shouldExecuteDefaultTriggers = false;
        }
      });
      if ((0, _types.isLensFilterEvent)(event) || (0, _types.isLensMultiFilterEvent)(event) || (0, _types.isLensBrushEvent)(event)) {
        if (shouldExecuteDefaultTriggers) {
          this.deps.getTrigger(_public2.VIS_EVENT_TO_TRIGGER[event.name]).exec({
            data: {
              ...event.data,
              timeFieldName: event.data.timeFieldName || (0, _utils.inferTimeField)(this.deps.data.datatableUtilities, event),
              query: esqlQuery
            },
            embeddable: this
          });
        }
      }
      if ((0, _types.isLensTableRowContextMenuClickEvent)(event)) {
        if (shouldExecuteDefaultTriggers) {
          this.deps.getTrigger(_public2.VIS_EVENT_TO_TRIGGER[event.name]).exec({
            data: event.data,
            embeddable: this
          }, true);
        }
      }

      // We allow for edit actions in the Embeddable for display purposes only (e.g. changing the datatable sort order).
      // No state changes made here with an edit action are persisted.
      if ((0, _types.isLensEditEvent)(event) && this.onEditAction) {
        if (!this.savedVis) return;

        // have to dance since this.savedVis.state is readonly
        const newVis = JSON.parse(JSON.stringify(this.savedVis));
        newVis.state.visualization = this.onEditAction(newVis.state.visualization, event);
        this.savedVis = newVis;
        const {
          ast
        } = await getExpressionFromDocument(this.savedVis, this.deps.documentToExpression);
        this.expression = ast;
        this.reload();
      }
    });
    (0, _defineProperty2.default)(this, "inputIsRefType", input => {
      return this.deps.attributeService.inputIsRefType(input);
    });
    (0, _defineProperty2.default)(this, "getInputAsRefType", async () => {
      return this.deps.attributeService.getInputAsRefType(this.getExplicitInput(), {
        showSaveModal: true,
        saveModalTitle: this.getTitle()
      });
    });
    (0, _defineProperty2.default)(this, "getInputAsValueType", async () => {
      return this.deps.attributeService.getInputAsValueType(this.getExplicitInput());
    });
    this.deps = deps;
    this.lensInspector = (0, _lens_inspector_service.getLensInspectorService)(deps.inspector);
    this.expressionRenderer = deps.expressionRenderer;
    this.initializeSavedVis(initialInput).then(() => {
      this.reload();
    }).catch(e => this.onFatalError(e));
    const input$ = this.getInput$();
    this.inputReloadSubscriptions = [];

    // Lens embeddable does not re-render when embeddable input changes in
    // general, to improve performance. This line makes sure the Lens embeddable
    // re-renders when anything in ".dynamicActions" (e.g. drilldowns) changes.
    this.inputReloadSubscriptions.push(input$.pipe((0, _rxjs.map)(input => {
      var _input$enhancements;
      return (_input$enhancements = input.enhancements) === null || _input$enhancements === void 0 ? void 0 : _input$enhancements.dynamicActions;
    }), (0, _rxjs.distinctUntilChanged)((a, b) => (0, _fastDeepEqual.default)(a, b)), (0, _rxjs.skip)(1)).subscribe(_input => {
      this.reload();
    }));

    // Lens embeddable does not re-render when embeddable input changes in
    // general, to improve performance. This line makes sure the Lens embeddable
    // re-renders when dashboard view mode switches between "view/edit". This is
    // needed to see the changes to ".dynamicActions" (e.g. drilldowns) when
    // dashboard's mode is toggled.
    this.inputReloadSubscriptions.push(input$.pipe((0, _rxjs.map)(input => input.viewMode), (0, _rxjs.distinctUntilChanged)(), (0, _rxjs.skip)(1)).subscribe(_input => {
      var _this$getInput$enhanc;
      // only reload if drilldowns are set
      if ((_this$getInput$enhanc = this.getInput().enhancements) !== null && _this$getInput$enhanc !== void 0 && _this$getInput$enhanc.dynamicActions) {
        this.reload();
      }
    }));

    // Use a trigger to distinguish between observables in the subscription
    const withTrigger = trigger => (0, _rxjs.map)(input => ({
      trigger,
      input
    }));

    // Re-initialize the visualization if either the attributes or the saved object id changes
    const attributesOrSavedObjectId$ = input$.pipe((0, _rxjs.distinctUntilChanged)((a, b) => (0, _fastDeepEqual.default)(['attributes' in a && a.attributes, 'savedObjectId' in a && a.savedObjectId, 'overrides' in a && a.overrides, 'disableTriggers' in a && a.disableTriggers], ['attributes' in b && b.attributes, 'savedObjectId' in b && b.savedObjectId, 'overrides' in b && b.overrides, 'disableTriggers' in b && b.disableTriggers])), (0, _rxjs.skip)(1), withTrigger('attributesOrSavedObjectId'));

    // Update search context and reload on changes related to search
    const searchContext$ = (0, _public3.shouldFetch$)(input$, () => this.getInput()).pipe(withTrigger('searchContext'));

    // Merge and debounce the observables to avoid multiple reloads
    this.inputReloadSubscriptions.push((0, _rxjs.merge)(searchContext$, attributesOrSavedObjectId$).pipe((0, _rxjs.debounceTime)(0), (0, _rxjs.switchMap)(async ({
      trigger,
      input
    }) => {
      if (trigger === 'attributesOrSavedObjectId') {
        await this.initializeSavedVis(input);
      }

      // reset removable messages
      // Dashboard search/context changes are detected here
      this.additionalUserMessages = {};
      this.reload();
    })).subscribe());
  }
  get activeDatasourceId() {
    return (0, _utils.getActiveDatasourceIdFromDoc)(this.savedVis);
  }
  get activeDatasource() {
    if (!this.activeDatasourceId) return;
    return this.deps.datasourceMap[this.activeDatasourceId];
  }
  get activeVisualizationId() {
    return (0, _utils.getActiveVisualizationIdFromDoc)(this.savedVis);
  }
  get activeVisualization() {
    if (!this.activeVisualizationId) return;
    return this.deps.visualizationMap[this.activeVisualizationId];
  }
  // TODO - consider getting this from the persistedStateToExpression function
  // where it is already computed
  get activeDatasourceState() {
    var _this$savedVis4, _this$savedVis5, _this$savedVis6;
    if (!this.activeDatasourceId || !this.activeDatasource) return;
    const docDatasourceState = (_this$savedVis4 = this.savedVis) === null || _this$savedVis4 === void 0 ? void 0 : _this$savedVis4.state.datasourceStates[this.activeDatasourceId];
    return this.activeDatasource.initialize(docDatasourceState, [...(((_this$savedVis5 = this.savedVis) === null || _this$savedVis5 === void 0 ? void 0 : _this$savedVis5.references) || []), ...(((_this$savedVis6 = this.savedVis) === null || _this$savedVis6 === void 0 ? void 0 : _this$savedVis6.state.internalReferences) || [])], undefined, undefined, this.indexPatterns);
  }
  reportsEmbeddableLoad() {
    return true;
  }
  supportedTriggers() {
    var _this$deps$visualizat4;
    if (!this.savedVis || !this.savedVis.visualizationType) {
      return [];
    }
    return ((_this$deps$visualizat4 = this.deps.visualizationMap[this.savedVis.visualizationType]) === null || _this$deps$visualizat4 === void 0 ? void 0 : _this$deps$visualizat4.triggers) || [];
  }
  getInspectorAdapters() {
    return this.lensInspector.adapters;
  }
  getFullAttributes() {
    return this.fullAttributes;
  }
  isTextBasedLanguage() {
    if (!this.savedVis) {
      return;
    }
    const query = this.savedVis.state.query;
    return !(0, _esQuery.isOfQueryType)(query);
  }
  getTextBasedLanguage() {
    var _this$savedVis7, _this$savedVis8;
    if (!this.isTextBasedLanguage() || !((_this$savedVis7 = this.savedVis) !== null && _this$savedVis7 !== void 0 && _this$savedVis7.state.query)) {
      return;
    }
    const query = (_this$savedVis8 = this.savedVis) === null || _this$savedVis8 === void 0 ? void 0 : _this$savedVis8.state.query;
    const language = (0, _esQuery.getAggregateQueryMode)(query);
    return (0, _esQuery.getLanguageDisplayName)(language).toUpperCase();
  }

  /**
   * Gets the Lens embeddable's datasource and visualization states
   * updates the embeddable input
   */
  async updateVisualization(datasourceState, visualizationState, visualizationType) {
    var _this$activeDatasourc3;
    const viz = this.savedVis;
    const activeDatasourceId = (_this$activeDatasourc3 = this.activeDatasourceId) !== null && _this$activeDatasourc3 !== void 0 ? _this$activeDatasourc3 : 'formBased';
    if (viz !== null && viz !== void 0 && viz.state) {
      const datasourceStates = {
        ...viz.state.datasourceStates,
        [activeDatasourceId]: datasourceState
      };
      const references = activeDatasourceId === 'formBased' ? (0, _utils.extractReferencesFromState)({
        activeDatasources: Object.keys(datasourceStates).reduce((acc, datasourceId) => ({
          ...acc,
          [datasourceId]: this.deps.datasourceMap[datasourceId]
        }), {}),
        datasourceStates: Object.fromEntries(Object.entries(datasourceStates).map(([id, state]) => [id, {
          isLoading: false,
          state
        }])),
        visualizationState,
        activeVisualization: this.activeVisualizationId ? this.deps.visualizationMap[visualizationType !== null && visualizationType !== void 0 ? visualizationType : this.activeVisualizationId] : undefined
      }) : [];
      const attrs = {
        ...viz,
        state: {
          ...viz.state,
          visualization: visualizationState,
          datasourceStates
        },
        references,
        visualizationType: visualizationType !== null && visualizationType !== void 0 ? visualizationType : viz.visualizationType
      };

      /**
       * SavedObjectId is undefined for by value panels and defined for the by reference ones.
       * Here we are converting the by reference panels to by value when user is inline editing
       */
      this.updateInput({
        attributes: attrs,
        savedObjectId: undefined
      });
      /**
       * Should load again the user messages,
       * otherwise the embeddable state is stuck in an error state
       */
      this.renderUserMessages();
    }
  }
  async updateSuggestion(attrs) {
    const viz = this.savedVis;
    const newViz = {
      ...viz,
      ...attrs
    };
    this.updateInput({
      attributes: newViz
    });
  }

  /**
   * Callback which allows the navigation to the editor.
   * Used for the Edit in Lens link inside the inline editing flyout.
   */
  async navigateToLensEditor() {
    var _appContext$currentAp, _appContext$getCurren;
    const appContext = this.getAppContext();
    /**
     * The origininating app variable is very important for the Save and Return button
     * of the editor to work properly.
     */
    const transferState = {
      originatingApp: (_appContext$currentAp = appContext === null || appContext === void 0 ? void 0 : appContext.currentAppId) !== null && _appContext$currentAp !== void 0 ? _appContext$currentAp : 'dashboards',
      originatingPath: appContext === null || appContext === void 0 ? void 0 : (_appContext$getCurren = appContext.getCurrentPath) === null || _appContext$getCurren === void 0 ? void 0 : _appContext$getCurren.call(appContext),
      valueInput: this.getExplicitInput(),
      embeddableId: this.id,
      searchSessionId: this.getInput().searchSessionId
    };
    const transfer = new _public3.EmbeddableStateTransfer(this.deps.coreStart.application.navigateToApp, this.deps.coreStart.application.currentAppId$);
    if (transfer) {
      await transfer.navigateToEditor(_constants.APP_ID, {
        path: this.output.editPath,
        state: transferState,
        skipAppLeave: true
      });
    }
  }
  updateByRefInput(savedObjectId) {
    const attrs = this.savedVis;
    this.updateInput({
      attributes: attrs,
      savedObjectId
    });
  }
  async openConfigPanel(startDependencies, isNewPanel, deletePanel) {
    var _this$activeDatasourc4;
    const {
      getEditLensConfiguration
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../async_services')));
    const Component = await getEditLensConfiguration(this.deps.coreStart, startDependencies, this.deps.visualizationMap, this.deps.datasourceMap);
    const datasourceId = (_this$activeDatasourc4 = this.activeDatasourceId) !== null && _this$activeDatasourc4 !== void 0 ? _this$activeDatasourc4 : 'formBased';
    const attributes = this.savedVis;
    if (attributes) {
      var _this$savedVis9;
      return /*#__PURE__*/_react.default.createElement(Component, {
        attributes: attributes,
        updatePanelState: this.updateVisualization.bind(this),
        updateSuggestion: this.updateSuggestion.bind(this),
        datasourceId: datasourceId,
        lensAdapters: this.lensInspector.adapters,
        output$: this.getOutput$(),
        panelId: this.id,
        savedObjectId: (_this$savedVis9 = this.savedVis) === null || _this$savedVis9 === void 0 ? void 0 : _this$savedVis9.savedObjectId,
        updateByRefInput: this.updateByRefInput.bind(this),
        navigateToLensEditor: !this.isTextBasedLanguage() ? this.navigateToLensEditor.bind(this) : undefined,
        displayFlyoutHeader: true,
        canEditTextBasedQuery: this.isTextBasedLanguage(),
        isNewPanel: isNewPanel,
        deletePanel: deletePanel
      });
    }
    return null;
  }
  async initializeSavedVis(input) {
    var _metaInfo$sharingSave;
    const unwrapResult = await this.deps.attributeService.unwrapAttributes(input).catch(e => {
      this.onFatalError(e);
      return false;
    });
    if (!unwrapResult || this.isDestroyed) {
      return;
    }
    const {
      metaInfo,
      attributes
    } = unwrapResult;
    this.fullAttributes = attributes;
    this.savedVis = {
      ...attributes,
      type: this.type,
      savedObjectId: input === null || input === void 0 ? void 0 : input.savedObjectId
    };
    if (this.isTextBasedLanguage()) {
      this.updateInput({
        disabledActions: ['OPEN_FLYOUT_ADD_DRILLDOWN']
      });
    }
    try {
      const {
        ast,
        indexPatterns,
        indexPatternRefs,
        activeVisualizationState
      } = await getExpressionFromDocument(this.savedVis, this.deps.documentToExpression);
      this.expression = ast;
      this.indexPatterns = indexPatterns;
      this.indexPatternRefs = indexPatternRefs;
      this.activeVisualizationState = activeVisualizationState;
    } catch {
      // nothing, errors should be reported via getUserMessages
    }
    if ((metaInfo === null || metaInfo === void 0 ? void 0 : (_metaInfo$sharingSave = metaInfo.sharingSavedObjectProps) === null || _metaInfo$sharingSave === void 0 ? void 0 : _metaInfo$sharingSave.outcome) === 'conflict' && !!this.deps.spaces) {
      var _metaInfo$sharingSave2;
      this.addUserMessages([{
        uniqueId: 'url-conflict',
        severity: 'error',
        displayLocations: [{
          id: 'visualization'
        }],
        shortMessage: _i18n.i18n.translate('xpack.lens.embeddable.legacyURLConflict.shortMessage', {
          defaultMessage: `You've encountered a URL conflict`
        }),
        longMessage: /*#__PURE__*/_react.default.createElement(this.deps.spaces.ui.components.getEmbeddableLegacyUrlConflict, {
          targetType: _constants.DOC_TYPE,
          sourceId: metaInfo === null || metaInfo === void 0 ? void 0 : (_metaInfo$sharingSave2 = metaInfo.sharingSavedObjectProps) === null || _metaInfo$sharingSave2 === void 0 ? void 0 : _metaInfo$sharingSave2.sourceId
        }),
        fixableInEditor: false
      }]);
    }
    await this.initializeOutput();

    // deferred loading of this embeddable is complete
    this.setInitializationFinished();
    this.isInitialized = true;
  }
  getSearchWarningMessages(adapters) {
    var _this$savedVis10;
    if (!this.activeDatasource || !this.activeDatasourceId || !(adapters !== null && adapters !== void 0 && adapters.requests)) {
      return [];
    }
    const docDatasourceState = (_this$savedVis10 = this.savedVis) === null || _this$savedVis10 === void 0 ? void 0 : _this$savedVis10.state.datasourceStates[this.activeDatasourceId];
    const requestWarnings = (0, _utils.getSearchWarningMessages)(adapters.requests, this.activeDatasource, docDatasourceState, {
      searchService: this.deps.data.search
    });
    return requestWarnings;
  }
  getExecutionContext() {
    if (this.savedVis) {
      var _this$parent, _this$savedVis$visual;
      const parentContext = ((_this$parent = this.parent) === null || _this$parent === void 0 ? void 0 : _this$parent.getInput().executionContext) || this.input.executionContext;
      const child = {
        type: 'lens',
        name: (_this$savedVis$visual = this.savedVis.visualizationType) !== null && _this$savedVis$visual !== void 0 ? _this$savedVis$visual : '',
        id: this.id,
        description: this.savedVis.title || this.input.title || '',
        url: this.output.editUrl
      };
      return parentContext ? {
        ...parentContext,
        child
      } : child;
    }
  }

  /**
   *
   * @param {HTMLElement} domNode
   * @param {ContainerState} containerState
   */
  render(domNode) {
    this.domNode = domNode;
    if (!this.savedVis || !this.isInitialized || this.isDestroyed) {
      return;
    }
    super.render(domNode);
    if (this.input.onLoad) {
      this.input.onLoad(true);
    }
    this.domNode.setAttribute('data-shared-item', '');
    const blockingErrors = this.getUserMessages(blockingMessageDisplayLocations, {
      severity: 'error'
    });
    this.updateOutput({
      loading: true,
      error: blockingErrors.length ? new Error(typeof blockingErrors[0].longMessage === 'string' ? blockingErrors[0].longMessage : blockingErrors[0].shortMessage) : undefined
    });
    if (blockingErrors.length) {
      this.renderComplete.dispatchError();
    } else {
      this.renderComplete.dispatchInProgress();
    }
    const input = this.getInput();
    const getInternalTables = states => {
      const result = {};
      if ('textBased' in states) {
        const layers = states.textBased.layers;
        for (const layer in layers) {
          if (layers[layer] && layers[layer].table) {
            result[layer] = layers[layer].table;
          }
        }
      }
      return result;
    };
    if (this.expression && !blockingErrors.length) {
      (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, this.deps.coreStart, /*#__PURE__*/_react.default.createElement(_expression_wrapper.ExpressionWrapper, {
        ExpressionRenderer: this.expressionRenderer,
        expression: this.expression || null,
        lensInspector: this.lensInspector,
        searchContext: this.getMergedSearchContext(),
        variables: {
          embeddableTitle: this.getTitle(),
          ...(input.palette ? {
            theme: {
              palette: input.palette
            }
          } : {}),
          ...('overrides' in input ? {
            overrides: input.overrides
          } : {}),
          ...getInternalTables(this.savedVis.state.datasourceStates)
        },
        searchSessionId: this.getInput().searchSessionId,
        handleEvent: this.handleEvent,
        onData$: this.updateActiveData,
        onRender$: this.onRender,
        interactive: !input.disableTriggers,
        renderMode: input.renderMode,
        syncColors: input.syncColors,
        syncTooltips: input.syncTooltips,
        syncCursor: input.syncCursor,
        hasCompatibleActions: this.hasCompatibleActions,
        getCompatibleCellValueActions: this.getCompatibleCellValueActions,
        className: input.className,
        style: input.style,
        executionContext: this.getExecutionContext(),
        abortController: this.input.abortController,
        addUserMessages: messages => this.addUserMessages(messages),
        onRuntimeError: error => {
          this.updateOutput({
            error
          });
          this.logError('runtime');
        },
        noPadding: this.visDisplayOptions.noPadding
      })), /*#__PURE__*/_react.default.createElement(MessagesBadge, {
        onMount: el => {
          this.badgeDomNode = el;
          this.renderBadgeMessages();
        }
      })), domNode);
    }
    this.renderUserMessages();
  }
  trackContentfulRender() {
    if (!this.activeData || !(0, _presentationContainers.canTrackContentfulRender)(this.parent)) {
      return;
    }
    const hasData = Object.values(this.activeData).some(table => {
      var _table$meta, _table$meta$statistic;
      if (((_table$meta = table.meta) === null || _table$meta === void 0 ? void 0 : (_table$meta$statistic = _table$meta.statistics) === null || _table$meta$statistic === void 0 ? void 0 : _table$meta$statistic.totalCount) != null) {
        // if totalCount is set, refer to total count
        return table.meta.statistics.totalCount > 0;
      }
      // if not, fall back to check the rows of the table
      return table.rows.length > 0;
    });
    if (hasData) {
      this.parent.trackContentfulRender();
    }
  }
  renderUserMessages() {
    const errors = this.getUserMessages(['visualization', 'visualizationOnEmbeddable'], {
      severity: 'error'
    });
    if (errors.length && this.domNode) {
      (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, this.deps.coreStart, /*#__PURE__*/_react.default.createElement(VisualizationErrorPanel, {
        errors: errors,
        canEdit: this.getIsEditable() && this.input.viewMode === 'edit'
      })), /*#__PURE__*/_react.default.createElement(MessagesBadge, {
        onMount: el => {
          this.badgeDomNode = el;
          this.renderBadgeMessages();
        }
      })), this.domNode);
    }
    this.renderBadgeMessages();
  }
  /**
   * Combines the embeddable context with the saved object context, and replaces
   * any references to index patterns
   */
  getMergedSearchContext() {
    var _input$filters;
    if (!this.savedVis) {
      throw new Error('savedVis is required for getMergedSearchContext');
    }
    const input = this.getInput();
    const context = {
      now: this.deps.data.nowProvider.get().getTime(),
      timeRange: input.timeslice !== undefined ? {
        from: new Date(input.timeslice[0]).toISOString(),
        to: new Date(input.timeslice[1]).toISOString(),
        mode: 'absolute'
      } : input.timeRange,
      query: [this.savedVis.state.query],
      filters: this.deps.injectFilterReferences(this.savedVis.state.filters, this.savedVis.references),
      disableWarningToasts: true
    };
    if (input.query) {
      context.query = [input.query, ...context.query];
    }
    if ((_input$filters = input.filters) !== null && _input$filters !== void 0 && _input$filters.length) {
      context.filters = [...input.filters.filter(filter => !filter.meta.disabled), ...context.filters];
    }
    return context;
  }
  get onEditAction() {
    var _this$savedVis11;
    const visType = (_this$savedVis11 = this.savedVis) === null || _this$savedVis11 === void 0 ? void 0 : _this$savedVis11.visualizationType;
    if (!visType) {
      return;
    }
    return this.deps.visualizationMap[visType].onEditAction;
  }
  reload() {
    if (!this.savedVis || !this.isInitialized || this.isDestroyed) {
      return;
    }
    if (this.domNode) {
      this.render(this.domNode);
    }
  }
  async loadViewUnderlyingDataArgs() {
    if (!this.savedVis || !this.activeData || !this.activeDatasource || !this.activeDatasourceState || !this.activeVisualization || !this.activeVisualizationState) {
      return false;
    }
    const mergedSearchContext = this.getMergedSearchContext();
    if (!mergedSearchContext.timeRange) {
      return false;
    }
    const viewUnderlyingDataArgs = getViewUnderlyingDataArgs({
      activeDatasource: this.activeDatasource,
      activeDatasourceState: this.activeDatasourceState,
      activeVisualization: this.activeVisualization,
      activeVisualizationState: this.activeVisualizationState,
      activeData: this.activeData,
      dataViews: this.internalDataViews,
      capabilities: this.deps.capabilities,
      query: mergedSearchContext.query,
      filters: mergedSearchContext.filters || [],
      timeRange: mergedSearchContext.timeRange,
      esQueryConfig: (0, _public.getEsQueryConfig)(this.deps.uiSettings),
      indexPatternsCache: this.indexPatterns
    });
    const loaded = typeof viewUnderlyingDataArgs !== 'undefined';
    if (loaded) {
      this.viewUnderlyingDataArgs = viewUnderlyingDataArgs;
    }
    return loaded;
  }

  /**
   * Returns the necessary arguments to view the underlying data in discover.
   *
   * Only makes sense to call this after canViewUnderlyingData has been checked
   */
  getViewUnderlyingDataArgs() {
    return this.viewUnderlyingDataArgs;
  }
  canViewUnderlyingData() {
    return this.loadViewUnderlyingDataArgs();
  }
  async initializeOutput() {
    var _this$savedVis12, _this$savedVis13, _input$title, _input$description;
    if (!this.savedVis) {
      return;
    }
    const {
      indexPatterns
    } = await (0, _utils.getIndexPatternsObjects)(((_this$savedVis12 = this.savedVis) === null || _this$savedVis12 === void 0 ? void 0 : _this$savedVis12.references.map(({
      id
    }) => id)) || [], this.deps.dataViews);
    (await Promise.all(Object.values(((_this$savedVis13 = this.savedVis) === null || _this$savedVis13 === void 0 ? void 0 : _this$savedVis13.state.adHocDataViews) || {}).map(spec => this.deps.dataViews.create(spec)))).forEach(dataView => indexPatterns.push(dataView));
    this.internalDataViews = (0, _lodash.uniqBy)(indexPatterns, 'id');

    // passing edit url and index patterns to the output of this embeddable for
    // the container to pick them up and use them to configure filter bar and
    // config dropdown correctly.
    const input = this.getInput();

    // if at least one indexPattern is time based, then the Lens embeddable requires the timeRange prop
    // this is necessary for the dataview embeddable but not the ES|QL one
    if (!Boolean(this.isTextBasedLanguage()) && input.timeRange == null && indexPatterns.some(indexPattern => indexPattern.isTimeBased())) {
      this.addUserMessages([{
        uniqueId: 'missing-time-range-on-embeddable',
        severity: 'error',
        fixableInEditor: false,
        displayLocations: [{
          id: 'visualization'
        }],
        shortMessage: _i18n.i18n.translate('xpack.lens.embeddable.missingTimeRangeParam.shortMessage', {
          defaultMessage: `Missing timeRange property`
        }),
        longMessage: _i18n.i18n.translate('xpack.lens.embeddable.missingTimeRangeParam.longMessage', {
          defaultMessage: `The timeRange property is required for the given configuration`
        })
      }]);
    }
    const blockingErrors = this.getUserMessages(blockingMessageDisplayLocations, {
      severity: 'error'
    });
    if (blockingErrors.length) {
      this.logError('validation');
    }
    const title = input.hidePanelTitles ? '' : (_input$title = input.title) !== null && _input$title !== void 0 ? _input$title : this.savedVis.title;
    const description = input.hidePanelTitles ? '' : (_input$description = input.description) !== null && _input$description !== void 0 ? _input$description : this.savedVis.description;
    const savedObjectId = input.savedObjectId;
    this.updateOutput({
      defaultTitle: this.savedVis.title,
      defaultDescription: this.savedVis.description,
      /** lens visualizations allow inline editing action
       *  navigation to the editor is allowed through the flyout
       */
      editable: this.getIsEditable(),
      inlineEditable: true,
      title,
      description,
      editPath: (0, _constants.getEditPath)(savedObjectId),
      editUrl: this.deps.basePath.prepend(`/app/lens${(0, _constants.getEditPath)(savedObjectId)}`),
      indexPatterns: this.internalDataViews
    });
  }
  getIsEditable() {
    // for ES|QL, editing is allowed only if the advanced setting is on
    if (Boolean(this.isTextBasedLanguage()) && !this.deps.uiSettings.get(_esqlUtils.ENABLE_ESQL)) {
      return false;
    }
    return this.deps.capabilities.canSaveVisualizations || !this.inputIsRefType(this.getInput()) && this.deps.capabilities.canSaveDashboards && this.deps.capabilities.canOpenVisualizations;
  }
  /**
   * Gets the Lens embeddable's local filters
   * @returns Local/panel-level array of filters for Lens embeddable
   */
  getFilters() {
    try {
      var _this$savedVis$state$, _this$savedVis14, _this$savedVis$refere, _this$savedVis15;
      return (0, _public.mapAndFlattenFilters)(this.deps.injectFilterReferences((_this$savedVis$state$ = (_this$savedVis14 = this.savedVis) === null || _this$savedVis14 === void 0 ? void 0 : _this$savedVis14.state.filters) !== null && _this$savedVis$state$ !== void 0 ? _this$savedVis$state$ : [], (_this$savedVis$refere = (_this$savedVis15 = this.savedVis) === null || _this$savedVis15 === void 0 ? void 0 : _this$savedVis15.references) !== null && _this$savedVis$refere !== void 0 ? _this$savedVis$refere : []));
    } catch (e) {
      // if we can't parse the filters, we publish an empty array.
      return [];
    }
  }

  /**
   * Gets the Lens embeddable's local query
   * @returns Local/panel-level query for Lens embeddable
   */
  getQuery() {
    var _this$savedVis16;
    return (_this$savedVis16 = this.savedVis) === null || _this$savedVis16 === void 0 ? void 0 : _this$savedVis16.state.query;
  }
  getSavedVis() {
    if (!this.savedVis) {
      return;
    }

    // Why are 'type' and 'savedObjectId' keys being removed?
    // Prior to removing them,
    // this method returned 'Readonly<Document | undefined>' while consumers typed the results as 'LensSavedObjectAttributes'.
    // Removing 'type' and 'savedObjectId' keys to align method results with consumer typing.
    const savedVis = {
      ...this.savedVis
    };
    delete savedVis.type;
    delete savedVis.savedObjectId;
    return savedVis;
  }
  destroy() {
    this.isDestroyed = true;
    super.destroy();
    if (this.inputReloadSubscriptions.length > 0) {
      this.inputReloadSubscriptions.forEach(reloadSub => {
        reloadSub.unsubscribe();
      });
    }
    if (this.domNode) {
      (0, _reactDom.unmountComponentAtNode)(this.domNode);
    }
  }
  getSelfStyledOptions() {
    return {
      hideTitle: this.visDisplayOptions.noPanelTitle
    };
  }
  get visDisplayOptions() {
    var _this$savedVis17, _this$deps$visualizat5, _this$deps$visualizat6, _this$deps$visualizat7;
    if (!((_this$savedVis17 = this.savedVis) !== null && _this$savedVis17 !== void 0 && _this$savedVis17.visualizationType)) {
      return {};
    }
    let displayOptions = (_this$deps$visualizat5 = (_this$deps$visualizat6 = this.deps.visualizationMap[this.savedVis.visualizationType]) === null || _this$deps$visualizat6 === void 0 ? void 0 : (_this$deps$visualizat7 = _this$deps$visualizat6.getDisplayOptions) === null || _this$deps$visualizat7 === void 0 ? void 0 : _this$deps$visualizat7.call(_this$deps$visualizat6)) !== null && _this$deps$visualizat5 !== void 0 ? _this$deps$visualizat5 : {};
    if (this.input.noPadding !== undefined) {
      displayOptions = {
        ...displayOptions,
        noPadding: this.input.noPadding
      };
    }
    return displayOptions;
  }
}
exports.Embeddable = Embeddable;