"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerPanel = LayerPanel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./layer_panel.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _layer_actions = require("./layer_actions");
var _types = require("../../../types");
var _layer_header = require("./layer_header");
var _dimension_container = require("./dimension_container");
var _empty_dimension_button = require("./buttons/empty_dimension_button");
var _draggable_dimension_button = require("./buttons/draggable_dimension_button");
var _use_focus_update = require("./use_focus_update");
var _state_management = require("../../../state_management");
var _layer_actions2 = require("./layer_actions/layer_actions");
var _flyout_container = require("../../../shared_components/flyout_container");
var _fake_dimension_button = require("./buttons/fake_dimension_button");
var _user_messages_utils = require("../../../user_messages_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LayerPanel(props) {
  var _framePublicAPI$datas, _datasourceStates$dat, _layerDatasource$uniq, _openColumnGroup$dime;
  const [openDimension, setOpenDimension] = (0, _react.useState)({});
  const [isPanelSettingsOpen, setPanelSettingsOpen] = (0, _react.useState)(false);
  const {
    framePublicAPI,
    layerId,
    isOnlyLayer,
    dimensionGroups,
    onRemoveLayer,
    onCloneLayer,
    registerNewLayerRef,
    layerIndex,
    activeVisualization,
    visualizationMap,
    datasourceMap,
    updateVisualization,
    updateDatasource,
    toggleFullscreen,
    updateAll,
    updateDatasourceAsync,
    visualizationState,
    onChangeIndexPattern,
    core,
    onDropToDimension,
    setIsInlineFlyoutVisible,
    onlyAllowSwitchToSubtypes
  } = props;
  const isInlineEditing = Boolean(props === null || props === void 0 ? void 0 : props.setIsInlineFlyoutVisible);
  const isSaveable = (0, _state_management.useLensSelector)(state => state.lens.isSaveable);
  const datasourceStates = (0, _state_management.useLensSelector)(_state_management.selectDatasourceStates);
  const isFullscreen = (0, _state_management.useLensSelector)(_state_management.selectIsFullscreenDatasource);
  const dateRange = (0, _state_management.useLensSelector)(_state_management.selectResolvedDateRange);
  (0, _react.useEffect)(() => {
    // is undefined when the dimension panel is closed
    setIsInlineFlyoutVisible === null || setIsInlineFlyoutVisible === void 0 ? void 0 : setIsInlineFlyoutVisible(!openDimension.openColumnId);
  }, [openDimension.openColumnId, setIsInlineFlyoutVisible]);
  const panelRef = (0, _react.useRef)(null);
  const settingsPanelRef = (0, _react.useRef)(null);
  const registerLayerRef = (0, _react.useCallback)(el => registerNewLayerRef(layerId, el), [layerId, registerNewLayerRef]);
  const closeDimensionEditor = () => {
    if (layerDatasource) {
      if (layerDatasource.updateStateOnCloseDimension) {
        const newState = layerDatasource.updateStateOnCloseDimension({
          state: layerDatasourceState,
          layerId,
          columnId: openColumnId
        });
        if (newState) {
          props.updateDatasource(datasourceId, newState);
        }
      }
    }
    setOpenDimension({});
    if (isFullscreen) {
      toggleFullscreen();
    }
  };
  const layerVisualizationConfigProps = {
    layerId,
    state: props.visualizationState,
    frame: props.framePublicAPI,
    dateRange,
    activeData: props.framePublicAPI.activeData
  };
  const datasourcePublicAPI = (_framePublicAPI$datas = framePublicAPI.datasourceLayers) === null || _framePublicAPI$datas === void 0 ? void 0 : _framePublicAPI$datas[layerId];
  const datasourceId = datasourcePublicAPI === null || datasourcePublicAPI === void 0 ? void 0 : datasourcePublicAPI.datasourceId;
  let layerDatasourceState = datasourceId ? datasourceStates === null || datasourceStates === void 0 ? void 0 : (_datasourceStates$dat = datasourceStates[datasourceId]) === null || _datasourceStates$dat === void 0 ? void 0 : _datasourceStates$dat.state : undefined;
  // try again with aliases
  if (!layerDatasourceState && datasourcePublicAPI !== null && datasourcePublicAPI !== void 0 && datasourcePublicAPI.datasourceAliasIds && datasourceStates) {
    const aliasId = datasourcePublicAPI.datasourceAliasIds.find(id => {
      var _datasourceStates$id;
      return datasourceStates === null || datasourceStates === void 0 ? void 0 : (_datasourceStates$id = datasourceStates[id]) === null || _datasourceStates$id === void 0 ? void 0 : _datasourceStates$id.state;
    });
    if (aliasId) {
      layerDatasourceState = datasourceStates[aliasId].state;
    }
  }
  const layerDatasource = datasourceId ? props.datasourceMap[datasourceId] : undefined;
  const layerDatasourceConfigProps = {
    state: layerDatasourceState,
    setState: newState => {
      updateDatasource(datasourceId, newState);
    },
    layerId,
    frame: props.framePublicAPI,
    dateRange
  };
  const columnLabelMap = !layerDatasource && activeVisualization.getUniqueLabels ? activeVisualization.getUniqueLabels(props.visualizationState) : layerDatasource === null || layerDatasource === void 0 ? void 0 : (_layerDatasource$uniq = layerDatasource.uniqueLabels) === null || _layerDatasource$uniq === void 0 ? void 0 : _layerDatasource$uniq.call(layerDatasource, layerDatasourceConfigProps === null || layerDatasourceConfigProps === void 0 ? void 0 : layerDatasourceConfigProps.state, framePublicAPI.dataViews.indexPatterns);
  const isEmptyLayer = !dimensionGroups.some(d => d.accessors.length > 0);
  const {
    openColumnId,
    openColumnGroup,
    isComplete
  } = openDimension;
  (0, _react.useEffect)(() => {
    if (!openColumnId) {
      return;
    }
    const derivedOpenColumnGroup = dimensionGroups.find(group => group.accessors.some(a => a.columnId === openColumnId));
    // dont update if nothing has changed
    if (isComplete === !!derivedOpenColumnGroup && (derivedOpenColumnGroup === null || derivedOpenColumnGroup === void 0 ? void 0 : derivedOpenColumnGroup.groupId) === (openColumnGroup === null || openColumnGroup === void 0 ? void 0 : openColumnGroup.groupId)) {
      return;
    }
    if (derivedOpenColumnGroup) {
      // if column is found, mark it as complete. If it's moved to another group, update the group
      setOpenDimension({
        openColumnId,
        openColumnGroup: derivedOpenColumnGroup,
        isComplete: !!derivedOpenColumnGroup
      });
    }
    // if column is not found but is not new (is complete), close the dimension panel
    if (isComplete && !derivedOpenColumnGroup) {
      setOpenDimension({});
    }
  }, [openColumnId, dimensionGroups, isComplete, openColumnGroup === null || openColumnGroup === void 0 ? void 0 : openColumnGroup.groupId]);
  const allAccessors = dimensionGroups.flatMap(group => group.accessors.map(accessor => accessor.columnId));
  const {
    setNextFocusedId: setNextFocusedButtonId,
    removeRef: removeButtonRef,
    registerNewRef: registerNewButtonRef
  } = (0, _use_focus_update.useFocusUpdate)(allAccessors);
  const onDrop = (0, _react.useCallback)((source, target, dropType) => {
    if (!dropType) {
      return;
    }
    if (!(0, _types.isOperation)(target)) {
      throw new Error('Drop target should be an operation');
    }
    if (dropType === 'reorder' || dropType === 'field_replace' || dropType === 'field_add') {
      setNextFocusedButtonId(source.id);
    } else {
      setNextFocusedButtonId(target.columnId);
    }
    onDropToDimension({
      source,
      target,
      dropType
    });
  }, [setNextFocusedButtonId, onDropToDimension]);
  const isDimensionPanelOpen = Boolean(openColumnId);
  const updateDataLayerState = (0, _react.useCallback)((newState, {
    isDimensionComplete = true,
    // this flag is a hack to force a sync render where it was planned an async/setTimeout state update
    // TODO: revisit this once we get rid of updateDatasourceAsync upstream
    forceRender = false
  } = {}) => {
    if (!openColumnGroup || !openColumnId) {
      return;
    }
    if (allAccessors.includes(openColumnId)) {
      if (isDimensionComplete) {
        if (forceRender) {
          updateDatasource(datasourceId, newState);
        } else {
          updateDatasourceAsync(datasourceId, newState);
        }
      } else {
        // The datasource can indicate that the previously-valid column is no longer
        // complete, which clears the visualization. This keeps the flyout open and reuses
        // the previous columnId
        props.updateDatasource(datasourceId, newState);
        props.onRemoveDimension({
          layerId,
          columnId: openColumnId
        });
      }
    } else if (isDimensionComplete) {
      updateAll(datasourceId, newState, activeVisualization.setDimension({
        layerId,
        groupId: openColumnGroup.groupId,
        columnId: openColumnId,
        prevState: visualizationState,
        frame: framePublicAPI
      }));
    } else {
      if (forceRender) {
        updateDatasource(datasourceId, newState);
      } else {
        updateDatasourceAsync(datasourceId, newState);
      }
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [openDimension, openColumnGroup, openColumnId, activeVisualization, datasourceId, layerId, updateAll, updateDatasourceAsync, visualizationState, framePublicAPI]);
  const {
    dataViews
  } = props.framePublicAPI;
  const [datasource] = Object.values(framePublicAPI.datasourceLayers);
  const isTextBasedLanguage = Boolean(datasource === null || datasource === void 0 ? void 0 : datasource.isTextBasedLanguage());
  const visualizationLayerSettings = (0, _react.useMemo)(() => {
    var _activeVisualization$;
    return ((_activeVisualization$ = activeVisualization.hasLayerSettings) === null || _activeVisualization$ === void 0 ? void 0 : _activeVisualization$.call(activeVisualization, {
      layerId,
      state: visualizationState,
      frame: props.framePublicAPI
    })) || {
      data: false,
      appearance: false
    };
  }, [activeVisualization, layerId, props.framePublicAPI, visualizationState]);
  const compatibleActions = (0, _react.useMemo)(() => {
    var _activeVisualization$2, _activeVisualization$3;
    return [...(((_activeVisualization$2 = activeVisualization.getSupportedActionsForLayer) === null || _activeVisualization$2 === void 0 ? void 0 : _activeVisualization$2.call(activeVisualization, layerId, visualizationState, updateVisualization, props.registerLibraryAnnotationGroup, isSaveable).map(action => ({
      ...action,
      execute: () => {
        action.execute(layerActionsFlyoutRef.current);
      }
    }))) || []), ...(0, _layer_actions2.getSharedActions)({
      layerId,
      activeVisualization,
      core,
      layerIndex,
      layerType: activeVisualization.getLayerType(layerId, visualizationState),
      isOnlyLayer,
      isTextBasedLanguage,
      hasLayerSettings: Boolean(Object.values(visualizationLayerSettings).some(Boolean) && activeVisualization.LayerSettingsComponent || (layerDatasource === null || layerDatasource === void 0 ? void 0 : layerDatasource.LayerSettingsComponent)),
      openLayerSettings: () => setPanelSettingsOpen(true),
      onCloneLayer,
      onRemoveLayer: () => onRemoveLayer(layerId),
      customRemoveModalText: (_activeVisualization$3 = activeVisualization.getCustomRemoveLayerText) === null || _activeVisualization$3 === void 0 ? void 0 : _activeVisualization$3.call(activeVisualization, layerId, visualizationState)
    })].filter(i => i.isCompatible);
  }, [activeVisualization, layerId, visualizationState, updateVisualization, props.registerLibraryAnnotationGroup, isSaveable, core, layerIndex, isOnlyLayer, isTextBasedLanguage, visualizationLayerSettings, layerDatasource === null || layerDatasource === void 0 ? void 0 : layerDatasource.LayerSettingsComponent, onCloneLayer, onRemoveLayer]);
  const layerActionsFlyoutRef = (0, _react.useRef)(null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("section", {
    tabIndex: -1,
    ref: registerLayerRef,
    className: "lnsLayerPanel",
    "data-test-subj": `lns-layerPanel-${layerIndex}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement("header", {
    className: "lnsLayerPanel__layerHeader"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: "lnsLayerPanel__layerSettingsWrapper"
  }, /*#__PURE__*/_react.default.createElement(_layer_header.LayerHeader, {
    layerConfigProps: {
      ...layerVisualizationConfigProps,
      setState: props.updateVisualization,
      onChangeIndexPattern: indexPatternId => onChangeIndexPattern({
        indexPatternId,
        layerId,
        visualizationId: activeVisualization.id
      })
    },
    activeVisualizationId: activeVisualization.id,
    visualizationMap: visualizationMap,
    datasourceMap: datasourceMap,
    onlyAllowSwitchToSubtypes: onlyAllowSwitchToSubtypes
  })), props.displayLayerSettings && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_layer_actions.LayerActions, {
    actions: compatibleActions,
    layerIndex: layerIndex,
    mountingPoint: layerActionsFlyoutRef.current
  }), /*#__PURE__*/_react.default.createElement("div", {
    ref: layerActionsFlyoutRef
  }))), props.indexPatternService && !isTextBasedLanguage && (layerDatasource || activeVisualization.LayerPanelComponent) && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), layerDatasource && props.indexPatternService && /*#__PURE__*/_react.default.createElement(layerDatasource.LayerPanelComponent, {
    layerId,
    state: layerDatasourceState,
    activeData: props.framePublicAPI.activeData,
    dataViews,
    onChangeIndexPattern: indexPatternId => onChangeIndexPattern({
      indexPatternId,
      layerId,
      datasourceId
    })
  }), activeVisualization.LayerPanelComponent && /*#__PURE__*/_react.default.createElement(activeVisualization.LayerPanelComponent, {
    layerId,
    state: visualizationState,
    frame: framePublicAPI,
    setState: props.updateVisualization,
    onChangeIndexPattern: indexPatternId => onChangeIndexPattern({
      indexPatternId,
      layerId,
      visualizationId: activeVisualization.id
    })
  })), dimensionGroups.filter(group => !group.isHidden).map((group, groupIndex) => {
    var _activeVisualization$6;
    let errorText = '';
    if (!isEmptyLayer || isInlineEditing) {
      if (group.requiredMinDimensionCount && group.requiredMinDimensionCount > group.accessors.length) {
        if (group.requiredMinDimensionCount > 1) {
          errorText = _i18n.i18n.translate('xpack.lens.editorFrame.requiresTwoOrMoreFieldsWarningLabel', {
            defaultMessage: 'Requires {requiredMinDimensionCount} fields',
            values: {
              requiredMinDimensionCount: group.requiredMinDimensionCount
            }
          });
        } else {
          errorText = _i18n.i18n.translate('xpack.lens.editorFrame.requiresFieldWarningLabel', {
            defaultMessage: 'Requires field'
          });
        }
      } else if (group.dimensionsTooMany && group.dimensionsTooMany > 0) {
        errorText = _i18n.i18n.translate('xpack.lens.editorFrame.tooManyDimensionsSingularWarningLabel', {
          defaultMessage: 'Please remove {dimensionsTooMany, plural, one {a dimension} other {{dimensionsTooMany} dimensions}}',
          values: {
            dimensionsTooMany: group.dimensionsTooMany
          }
        });
      }
    }
    const isOptional = !group.requiredMinDimensionCount && !group.suggestedValue;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      className: "lnsLayerPanel__row",
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, group.groupLabel, group.groupTooltip && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        color: "subdued",
        content: group.groupTooltip,
        iconProps: {
          className: 'eui-alignTop'
        },
        position: "top",
        size: "s",
        type: "questionInCircle"
      }))),
      labelAppend: isOptional ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "xs",
        "data-test-subj": "lnsGroup_optional"
      }, _i18n.i18n.translate('xpack.lens.editorFrame.optionalDimensionLabel', {
        defaultMessage: 'Optional'
      })) : null,
      labelType: "legend",
      key: group.groupId,
      isInvalid: Boolean(errorText),
      error: errorText
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, group.accessors.length ? /*#__PURE__*/_react.default.createElement(_domDragDrop.ReorderProvider, {
      className: 'lnsLayerPanel__group',
      dataTestSubj: "lnsDragDrop"
    }, group.accessors.map((accessorConfig, accessorIndex) => {
      var _props$getUserMessage, _props$getUserMessage2, _activeVisualization$4, _columnLabelMap$colum, _columnLabelMap$acces, _activeVisualization$5, _columnLabelMap$colum2;
      const {
        columnId
      } = accessorConfig;
      const messages = (_props$getUserMessage = props === null || props === void 0 ? void 0 : (_props$getUserMessage2 = props.getUserMessages) === null || _props$getUserMessage2 === void 0 ? void 0 : _props$getUserMessage2.call(props, 'dimensionButton', {
        dimensionId: columnId
      })) !== null && _props$getUserMessage !== void 0 ? _props$getUserMessage : [];
      const firstMessage = messages.at(0);
      return /*#__PURE__*/_react.default.createElement(_draggable_dimension_button.DraggableDimensionButton, {
        activeVisualization: activeVisualization,
        registerNewButtonRef: registerNewButtonRef,
        order: [2, layerIndex, groupIndex, accessorIndex],
        target: {
          id: columnId,
          layerId,
          columnId,
          groupId: group.groupId,
          filterOperations: group.filterOperations,
          prioritizedOperation: group.prioritizedOperation,
          isMetricDimension: group === null || group === void 0 ? void 0 : group.isMetricDimension,
          indexPatternId: layerDatasource ? layerDatasource.getUsedDataView(layerDatasourceState, layerId) : (_activeVisualization$4 = activeVisualization.getUsedDataView) === null || _activeVisualization$4 === void 0 ? void 0 : _activeVisualization$4.call(activeVisualization, visualizationState, layerId),
          humanData: {
            label: (_columnLabelMap$colum = columnLabelMap === null || columnLabelMap === void 0 ? void 0 : columnLabelMap[columnId]) !== null && _columnLabelMap$colum !== void 0 ? _columnLabelMap$colum : '',
            groupLabel: group.groupLabel,
            position: accessorIndex + 1,
            layerNumber: layerIndex + 1
          }
        },
        group: group,
        key: columnId,
        state: layerDatasourceState,
        layerDatasource: layerDatasource,
        datasourceLayers: framePublicAPI.datasourceLayers,
        onDrop: onDrop,
        indexPatterns: dataViews.indexPatterns
      }, /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DimensionButton, {
        accessorConfig: accessorConfig,
        label: (_columnLabelMap$acces = columnLabelMap === null || columnLabelMap === void 0 ? void 0 : columnLabelMap[accessorConfig.columnId]) !== null && _columnLabelMap$acces !== void 0 ? _columnLabelMap$acces : '',
        groupLabel: group.groupLabel,
        onClick: id => {
          setOpenDimension({
            openColumnGroup: group,
            openColumnId: id
          });
        },
        onRemoveClick: id => {
          props.onRemoveDimension({
            columnId: id,
            layerId
          });
          removeButtonRef(id);
        },
        message: firstMessage ? {
          severity: firstMessage.severity,
          content: firstMessage.shortMessage || (0, _user_messages_utils.getLongMessage)(firstMessage)
        } : undefined
      }, layerDatasource ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, layerDatasource.DimensionTriggerComponent({
        ...layerDatasourceConfigProps,
        columnId: accessorConfig.columnId,
        groupId: group.groupId,
        filterOperations: group.filterOperations,
        indexPatterns: dataViews.indexPatterns
      })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, activeVisualization === null || activeVisualization === void 0 ? void 0 : (_activeVisualization$5 = activeVisualization.DimensionTriggerComponent) === null || _activeVisualization$5 === void 0 ? void 0 : _activeVisualization$5.call(activeVisualization, {
        columnId,
        label: (_columnLabelMap$colum2 = columnLabelMap === null || columnLabelMap === void 0 ? void 0 : columnLabelMap[columnId]) !== null && _columnLabelMap$colum2 !== void 0 ? _columnLabelMap$colum2 : ''
      }))));
    })) : null, group.fakeFinalAccessor && /*#__PURE__*/_react.default.createElement(_fake_dimension_button.FakeDimensionButton, {
      label: group.fakeFinalAccessor.label
    }), group.supportsMoreColumns ? /*#__PURE__*/_react.default.createElement(_empty_dimension_button.EmptyDimensionButton, {
      activeVisualization: activeVisualization,
      order: [2, layerIndex, groupIndex, group.accessors.length],
      group: group,
      target: {
        layerId,
        groupId: group.groupId,
        filterOperations: group.filterOperations,
        prioritizedOperation: group.prioritizedOperation,
        isNewColumn: true,
        isMetricDimension: group === null || group === void 0 ? void 0 : group.isMetricDimension,
        indexPatternId: layerDatasource ? layerDatasource.getUsedDataView(layerDatasourceState, layerId) : (_activeVisualization$6 = activeVisualization.getUsedDataView) === null || _activeVisualization$6 === void 0 ? void 0 : _activeVisualization$6.call(activeVisualization, visualizationState, layerId),
        humanData: {
          groupLabel: group.groupLabel,
          layerNumber: layerIndex + 1,
          position: group.accessors.length + 1,
          label: _i18n.i18n.translate('xpack.lens.indexPattern.emptyDimensionButton', {
            defaultMessage: 'Empty dimension'
          })
        }
      },
      layerDatasource: layerDatasource,
      state: layerDatasourceState,
      datasourceLayers: framePublicAPI.datasourceLayers,
      onClick: id => {
        props.onEmptyDimensionAdd(id, group);
        setOpenDimension({
          openColumnGroup: group,
          openColumnId: id
        });
      },
      onDrop: onDrop,
      indexPatterns: dataViews.indexPatterns
    }) : null));
  }))), ((layerDatasource === null || layerDatasource === void 0 ? void 0 : layerDatasource.LayerSettingsComponent) || (activeVisualization === null || activeVisualization === void 0 ? void 0 : activeVisualization.LayerSettingsComponent)) && /*#__PURE__*/_react.default.createElement(_flyout_container.FlyoutContainer, {
    panelRef: el => settingsPanelRef.current = el,
    isFullscreen: false,
    label: _i18n.i18n.translate('xpack.lens.editorFrame.layerSettingsTitle', {
      defaultMessage: 'Layer settings'
    }),
    isOpen: isPanelSettingsOpen,
    handleClose: () => {
      setPanelSettingsOpen(false);
    },
    isInlineEditing: isInlineEditing
  }, /*#__PURE__*/_react.default.createElement("div", {
    id: layerId
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsIndexPatternDimensionEditor--padded"
  }, layerDatasource !== null && layerDatasource !== void 0 && layerDatasource.LayerSettingsComponent || visualizationLayerSettings.data ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
                    margin-bottom: ${_uiTheme.euiThemeVars.euiSize};
                  `
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.lens.editorFrame.layerSettings.headingData', {
    defaultMessage: 'Data'
  }))) : null, (layerDatasource === null || layerDatasource === void 0 ? void 0 : layerDatasource.LayerSettingsComponent) && /*#__PURE__*/_react.default.createElement(layerDatasource.LayerSettingsComponent, layerDatasourceConfigProps), layerDatasource !== null && layerDatasource !== void 0 && layerDatasource.LayerSettingsComponent && visualizationLayerSettings.data ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }) : null, activeVisualization !== null && activeVisualization !== void 0 && activeVisualization.LayerSettingsComponent && visualizationLayerSettings.data ? /*#__PURE__*/_react.default.createElement(activeVisualization.LayerSettingsComponent, (0, _extends2.default)({}, layerVisualizationConfigProps, {
    setState: props.updateVisualization,
    panelRef: settingsPanelRef,
    section: 'data'
  })) : null, visualizationLayerSettings.appearance ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
                    margin-bottom: ${_uiTheme.euiThemeVars.euiSize};
                  `
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.lens.editorFrame.layerSettings.headingAppearance', {
    defaultMessage: 'Appearance'
  }))) : null, (activeVisualization === null || activeVisualization === void 0 ? void 0 : activeVisualization.LayerSettingsComponent) && /*#__PURE__*/_react.default.createElement(activeVisualization.LayerSettingsComponent, (0, _extends2.default)({}, layerVisualizationConfigProps, {
    setState: props.updateVisualization,
    panelRef: settingsPanelRef,
    section: 'appearance'
  }))))), /*#__PURE__*/_react.default.createElement(_dimension_container.DimensionContainer, {
    panelRef: el => panelRef.current = el,
    isOpen: isDimensionPanelOpen,
    isFullscreen: isFullscreen,
    label: (_openColumnGroup$dime = openColumnGroup === null || openColumnGroup === void 0 ? void 0 : openColumnGroup.dimensionEditorGroupLabel) !== null && _openColumnGroup$dime !== void 0 ? _openColumnGroup$dime : (openColumnGroup === null || openColumnGroup === void 0 ? void 0 : openColumnGroup.groupLabel) || '',
    isInlineEditing: isInlineEditing,
    handleClose: closeDimensionEditor,
    panel: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, openColumnGroup && openColumnId && layerDatasource && layerDatasource.DimensionEditorComponent({
      ...layerDatasourceConfigProps,
      core: props.core,
      columnId: openColumnId,
      groupId: openColumnGroup.groupId,
      hideGrouping: openColumnGroup.hideGrouping,
      filterOperations: openColumnGroup.filterOperations,
      isMetricDimension: openColumnGroup === null || openColumnGroup === void 0 ? void 0 : openColumnGroup.isMetricDimension,
      dimensionGroups,
      toggleFullscreen,
      isFullscreen,
      setState: updateDataLayerState,
      supportStaticValue: Boolean(openColumnGroup.supportStaticValue),
      paramEditorCustomProps: openColumnGroup.paramEditorCustomProps,
      enableFormatSelector: openColumnGroup.enableFormatSelector !== false,
      layerType: activeVisualization.getLayerType(layerId, visualizationState),
      indexPatterns: dataViews.indexPatterns,
      activeData: layerVisualizationConfigProps.activeData,
      dataSectionExtra: !isFullscreen && openDimension.isComplete && activeVisualization.DimensionEditorDataExtraComponent && /*#__PURE__*/_react.default.createElement(activeVisualization.DimensionEditorDataExtraComponent, (0, _extends2.default)({}, layerVisualizationConfigProps, {
        groupId: openColumnGroup.groupId,
        accessor: openColumnId,
        datasource,
        setState: props.updateVisualization,
        addLayer: props.addLayer,
        removeLayer: props.onRemoveLayer,
        panelRef
      }))
    }), openColumnGroup && openColumnId && !isFullscreen && openDimension.isComplete && activeVisualization.DimensionEditorComponent && (openColumnGroup === null || openColumnGroup === void 0 ? void 0 : openColumnGroup.enableDimensionEditor) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "lnsLayerPanel__styleEditor"
    }, /*#__PURE__*/_react.default.createElement(activeVisualization.DimensionEditorComponent, (0, _extends2.default)({}, layerVisualizationConfigProps, {
      groupId: openColumnGroup.groupId,
      accessor: openColumnId,
      datasource,
      setState: props.updateVisualization,
      addLayer: props.addLayer,
      removeLayer: props.onRemoveLayer,
      panelRef,
      isInlineEditing
    }))), activeVisualization.DimensionEditorAdditionalSectionComponent && /*#__PURE__*/_react.default.createElement(activeVisualization.DimensionEditorAdditionalSectionComponent, (0, _extends2.default)({}, layerVisualizationConfigProps, {
      groupId: openColumnGroup.groupId,
      accessor: openColumnId,
      datasource,
      setState: props.updateVisualization,
      addLayer: props.addLayer,
      removeLayer: props.onRemoveLayer,
      panelRef
    }))))
  }));
}