"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchDataFromAggregateQuery = fetchDataFromAggregateQuery;
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function fetchDataFromAggregateQuery(query, dataView, data, expressions, filters, inputQuery) {
  const timeRange = data.query.timefilter.timefilter.getTime();
  return (0, _common.textBasedQueryStateToAstWithValidation)({
    filters,
    query,
    time: timeRange,
    dataView,
    inputQuery
  }).then(ast => {
    if (ast) {
      const execution = expressions.run(ast, null);
      let finalData;
      let error;
      execution.pipe((0, _rxjs.pluck)('result')).subscribe(resp => {
        const response = resp;
        if (response.type === 'error') {
          error = response.error.message;
        } else {
          finalData = response;
        }
      });
      return (0, _rxjs.lastValueFrom)(execution).then(() => {
        if (error) {
          throw new Error(error);
        } else {
          return finalData;
        }
      });
    }
    return undefined;
  }).catch(err => {
    throw new Error(err.message);
  });
}