"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDropProps = void 0;
var _types = require("../../../types");
var _utils = require("../../../utils");
var _utils2 = require("../utils");
var _fieldlist_cache = require("../fieldlist_cache");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDropProps = props => {
  const {
    source,
    target,
    state
  } = props;
  if (!source || source.id === target.columnId) {
    return;
  }
  const layer = state.layers[target.layerId];
  const allColumns = (0, _fieldlist_cache.retrieveLayerColumnsFromCache)(layer.columns, layer.query);
  const targetColumn = layer.columns.find(f => f.columnId === target.columnId);
  const targetField = allColumns.find(f => f.columnId === target.columnId);
  const sourceField = allColumns.find(f => f.columnId === source.id);
  if ((0, _utils.isDraggedField)(source)) {
    const nextLabel = source.humanData.label;
    if (target !== null && target !== void 0 && target.isMetricDimension && sourceField && (0, _utils2.isNotNumeric)(sourceField)) {
      return;
    }
    return {
      dropTypes: [targetColumn ? 'field_replace' : 'field_add'],
      nextLabel
    };
  }
  if ((0, _types.isOperation)(source)) {
    var _sourceField$meta, _targetField$meta;
    if (source.layerId !== target.layerId) return;
    const nextLabel = source.humanData.label;
    if ((0, _utils.isOperationFromTheSameGroup)(source, target)) {
      if (!targetColumn) {
        return {
          dropTypes: ['duplicate_compatible'],
          nextLabel
        };
      }
      return {
        dropTypes: ['reorder'],
        nextLabel
      };
    }
    const sourceFieldCanMoveToMetricDimension = (0, _utils2.canColumnBeDroppedInMetricDimension)(allColumns, sourceField === null || sourceField === void 0 ? void 0 : (_sourceField$meta = sourceField.meta) === null || _sourceField$meta === void 0 ? void 0 : _sourceField$meta.type);
    const targetFieldCanMoveToMetricDimension = (0, _utils2.canColumnBeDroppedInMetricDimension)(allColumns, targetField === null || targetField === void 0 ? void 0 : (_targetField$meta = targetField.meta) === null || _targetField$meta === void 0 ? void 0 : _targetField$meta.type);
    const isMoveable = !(target !== null && target !== void 0 && target.isMetricDimension) || target.isMetricDimension && sourceFieldCanMoveToMetricDimension;
    if (targetColumn) {
      const isSwappable = isMoveable && !(source !== null && source !== void 0 && source.isMetricDimension) || source.isMetricDimension && targetFieldCanMoveToMetricDimension;
      if (isMoveable) {
        if (isSwappable) {
          return {
            dropTypes: ['replace_compatible', 'replace_duplicate_compatible', 'swap_compatible'],
            nextLabel
          };
        }
        return {
          dropTypes: ['replace_compatible', 'replace_duplicate_compatible'],
          nextLabel
        };
      }
    } else {
      if (isMoveable) {
        return {
          dropTypes: ['move_compatible', 'duplicate_compatible'],
          nextLabel
        };
      }
    }
  }
  return;
};
exports.getDropProps = getDropProps;