"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterPopover = void 0;
require("./filter_popover.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../../../common/constants");
var _ = require(".");
var _shared_components = require("../shared_components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Need to keep it separate to make it work Jest mocks in dimension_panel tests
// import { QueryInput } from '../../../../shared_components/query_input';

const FilterPopover = ({
  filter,
  setFilter,
  indexPattern,
  button,
  isOpen,
  triggerClose
}) => {
  const inputRef = _react.default.useRef();
  const [localFilter, setLocalFilter] = (0, _react.useState)(() => filter);
  const setFilterLabel = label => {
    setLocalFilter({
      ...localFilter,
      label
    });
    setFilter({
      ...filter,
      label
    });
  };
  const setFilterQuery = input => {
    setLocalFilter({
      ...localFilter,
      input
    });
    if ((0, _visualizationUiComponents.isQueryValid)(input, indexPattern)) {
      setFilter({
        ...filter,
        input
      });
    }
  };
  const getPlaceholder = query => {
    if (query === '') {
      return _.defaultLabel;
    }
    if (query === 'object') return JSON.stringify(query);else {
      return String(query);
    }
  };
  const closePopover = () => {
    setLocalFilter({
      ...localFilter,
      input: filter.input
    });
    triggerClose();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "indexPattern-filters-existingFilterContainer",
    panelClassName: "lnsIndexPatternDimensionEditor__filtersEditor",
    isOpen: isOpen,
    ownFocus: true,
    closePopover: closePopover,
    button: button
  }, /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.QueryInput, {
    isInvalid: !(0, _visualizationUiComponents.isQueryValid)(localFilter.input, indexPattern),
    value: localFilter.input,
    dataView: indexPattern.id ? {
      type: 'id',
      value: indexPattern.id
    } : {
      type: 'title',
      value: indexPattern.title
    },
    disableAutoFocus: true,
    onChange: setFilterQuery,
    onSubmit: () => {
      if (inputRef.current) inputRef.current.focus();
    },
    appName: _constants.LENS_APP_NAME,
    services: (0, _public.useKibana)().services
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_shared_components.LabelInput, {
    value: localFilter.label || '',
    onChange: setFilterLabel,
    placeholder: getPlaceholder(localFilter.input.query),
    inputRef: inputRef,
    onSubmit: closePopover,
    dataTestSubj: "indexPattern-filters-label"
  }));
};
exports.FilterPopover = FilterPopover;