"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WrappingHelpPopover = exports.HelpPopoverButton = exports.HelpPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
require("./help_popover.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HelpPopoverButton = ({
  children,
  onClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    className: "lnsHelpPopover__buttonIcon",
    size: "s",
    type: "help"
  }), children));
};
exports.HelpPopoverButton = HelpPopoverButton;
const HelpPopover = ({
  anchorPosition,
  button,
  children,
  closePopover,
  isOpen,
  title
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: anchorPosition,
    button: button,
    className: "lnsHelpPopover",
    closePopover: closePopover,
    isOpen: isOpen,
    ownFocus: true,
    panelClassName: "lnsHelpPopover__panel",
    panelPaddingSize: "none"
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "m"
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "lnsHelpPopover__content",
    size: "s"
  }, children));
};
exports.HelpPopover = HelpPopover;
const WrappingHelpPopover = ({
  anchorPosition,
  button,
  children,
  closePopover,
  isOpen,
  title,
  startServices
}) => {
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, startServices, /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    anchorPosition: anchorPosition,
    button: button,
    className: "lnsHelpPopover",
    closePopover: closePopover,
    isOpen: isOpen,
    ownFocus: true,
    panelClassName: "lnsHelpPopover__panel",
    panelPaddingSize: "none"
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "m"
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "lnsHelpPopover__content",
    size: "s"
  }, children)));
};
exports.WrappingHelpPopover = WrappingHelpPopover;