"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestions = exports.getGridAttrs = void 0;
var _esqlUtils = require("@kbn/esql-utils");
var _esQuery = require("@kbn/es-query");
var _visualizationUtils = require("@kbn/visualization-utils");
var _common = require("@kbn/data-plugin/common");
var _lens_suggestions_api = require("../../../lens_suggestions_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDSLFilter = (queryService, timeFieldName) => {
  const kqlQuery = queryService.queryString.getQuery();
  const filters = queryService.filterManager.getFilters();
  const timeFilter = queryService.timefilter.timefilter.getTime() && (0, _common.getTime)(undefined, queryService.timefilter.timefilter.getTime(), {
    fieldName: timeFieldName
  });
  return (0, _esQuery.buildEsQuery)(undefined, kqlQuery || [], [...(filters !== null && filters !== void 0 ? filters : []), ...(timeFilter ? [timeFilter] : [])]);
};
const getGridAttrs = async (query, adHocDataViews, deps, abortController) => {
  const indexPattern = (0, _esqlUtils.getIndexPatternFromESQLQuery)(query.esql);
  const dataViewSpec = adHocDataViews.find(adHoc => {
    return adHoc.name === indexPattern;
  });
  const dataView = dataViewSpec ? await deps.dataViews.create(dataViewSpec) : await (0, _esqlUtils.getESQLAdHocDataview)(query.esql, deps.dataViews);
  const filter = getDSLFilter(deps.data.query, dataView.timeFieldName);
  const results = await (0, _esqlUtils.getESQLResults)({
    esqlQuery: query.esql,
    search: deps.data.search.search,
    signal: abortController === null || abortController === void 0 ? void 0 : abortController.signal,
    filter,
    dropNullColumns: true,
    timeRange: deps.data.query.timefilter.timefilter.getAbsoluteTime()
  });
  const columns = (0, _esqlUtils.formatESQLColumns)(results.response.columns);
  return {
    rows: results.response.values,
    dataView,
    columns
  };
};
exports.getGridAttrs = getGridAttrs;
const getSuggestions = async (query, deps, datasourceMap, visualizationMap, adHocDataViews, setErrors, abortController, setDataGridAttrs) => {
  try {
    var _suggestionsApi;
    const {
      dataView,
      columns,
      rows
    } = await getGridAttrs(query, adHocDataViews, deps, abortController);
    setDataGridAttrs === null || setDataGridAttrs === void 0 ? void 0 : setDataGridAttrs({
      rows,
      dataView,
      columns
    });
    const context = {
      dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toSpec(false),
      fieldName: '',
      textBasedColumns: columns,
      query
    };
    const allSuggestions = (_suggestionsApi = (0, _lens_suggestions_api.suggestionsApi)({
      context,
      dataView,
      datasourceMap,
      visualizationMap
    })) !== null && _suggestionsApi !== void 0 ? _suggestionsApi : [];

    // Lens might not return suggestions for some cases, i.e. in case of errors
    if (!allSuggestions.length) return undefined;
    const firstSuggestion = allSuggestions[0];
    const attrs = (0, _visualizationUtils.getLensAttributesFromSuggestion)({
      filters: [],
      query,
      suggestion: firstSuggestion,
      dataView
    });
    return attrs;
  } catch (e) {
    setErrors([e]);
  }
  return undefined;
};
exports.getSuggestions = getSuggestions;