"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveModalContainer = SaveModalContainer;
exports.default = void 0;
exports.removePinnedFilters = removePinnedFilters;
exports.runSaveLensVisualization = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _eui = require("@elastic/eui");
var _save_modal = require("./save_modal");
var _persistence = require("../persistence");
var _constants = require("../../common/constants");
var _load_initial = require("../state_management/init_middleware/load_initial");
var _save_modal_container_helpers = require("./save_modal_container_helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SaveModalContainer({
  returnToOriginSwitchLabel,
  onClose,
  onSave,
  runSave,
  persistedDoc,
  originatingApp,
  getOriginatingPath,
  initialInput,
  redirectTo,
  redirectToOrigin,
  getAppNameFromId = () => undefined,
  isSaveable = true,
  lastKnownDoc: initLastKnownDoc,
  lensServices,
  initialContext,
  managed
}) {
  let title = '';
  let description;
  let savedObjectId;
  const [initializing, setInitializing] = (0, _react.useState)(true);
  const [lastKnownDoc, setLastKnownDoc] = (0, _react.useState)(initLastKnownDoc);
  if (lastKnownDoc) {
    title = lastKnownDoc.title;
    description = lastKnownDoc.description;
    savedObjectId = lastKnownDoc.savedObjectId;
  }
  if (!(lastKnownDoc !== null && lastKnownDoc !== void 0 && lastKnownDoc.title) && initialContext && 'isEmbeddable' in initialContext && initialContext.isEmbeddable) {
    title = _i18n.i18n.translate('xpack.lens.app.convertedLabel', {
      defaultMessage: '{title} (converted)',
      values: {
        title: initialContext.title || `${initialContext.visTypeTitle} visualization`
      }
    });
  }
  const {
    attributeService,
    savedObjectsTagging,
    application
  } = lensServices;
  (0, _react.useEffect)(() => {
    setLastKnownDoc(initLastKnownDoc);
  }, [initLastKnownDoc]);
  (0, _react.useEffect)(() => {
    let isMounted = true;
    if (initialInput) {
      (0, _load_initial.getPersisted)({
        initialInput,
        lensServices
      }).then(persisted => {
        if (persisted !== null && persisted !== void 0 && persisted.doc && isMounted) setLastKnownDoc(persisted.doc);
      }).finally(() => {
        setInitializing(false);
      });
    } else {
      setInitializing(false);
    }
    return () => {
      isMounted = false;
    };
  }, [initialInput, lensServices]);
  const tagsIds = persistedDoc && savedObjectsTagging ? savedObjectsTagging.ui.getTagIdsFromReferences(persistedDoc.references) : [];
  const runLensSave = (saveProps, options) => {
    if (runSave) {
      // inside lens, we use the function that's passed to it
      runSave(saveProps, options);
    } else if (attributeService && lastKnownDoc) {
      runSaveLensVisualization({
        ...lensServices,
        lastKnownDoc,
        initialInput,
        redirectTo,
        redirectToOrigin,
        originatingApp,
        getOriginatingPath,
        getIsByValueMode: () => false,
        onAppLeave: () => {},
        ...lensServices
      }, saveProps, options).then(() => {
        onSave === null || onSave === void 0 ? void 0 : onSave(saveProps);
        onClose();
      });
    }
  };
  if (initializing) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  const savingToLibraryPermitted = Boolean(isSaveable && application.capabilities.visualize.save);
  return /*#__PURE__*/_react.default.createElement(_save_modal.SaveModal, {
    originatingApp: originatingApp,
    getOriginatingPath: getOriginatingPath,
    savingToLibraryPermitted: savingToLibraryPermitted,
    savedObjectsTagging: savedObjectsTagging,
    tagsIds: tagsIds,
    onSave: (saveProps, options) => {
      runLensSave(saveProps, options);
    },
    onClose: onClose,
    getAppNameFromId: getAppNameFromId,
    title: title,
    description: description,
    savedObjectId: savedObjectId,
    returnToOriginSwitchLabel: returnToOriginSwitchLabel,
    returnToOrigin: redirectToOrigin != null,
    managed: Boolean(managed)
  });
}
const getDocToSave = (lastKnownDoc, saveProps, references) => {
  const docToSave = {
    ...removePinnedFilters(lastKnownDoc),
    references
  };
  if (saveProps.newDescription !== undefined) {
    docToSave.description = saveProps.newDescription;
  }
  if (saveProps.newTitle !== undefined) {
    docToSave.title = saveProps.newTitle;
  }
  return docToSave;
};
const runSaveLensVisualization = async (props, saveProps, options) => {
  const {
    chrome,
    initialInput,
    lastKnownDoc,
    persistedDoc,
    notifications,
    stateTransfer,
    attributeService,
    savedObjectsTagging,
    getIsByValueMode,
    redirectToOrigin,
    onAppLeave,
    redirectTo,
    textBasedLanguageSave,
    switchDatasource,
    application,
    savedObjectStore,
    getOriginatingPath,
    originatingApp,
    ...startServices
  } = props;
  if (!lastKnownDoc) {
    return;
  }
  let references = lastKnownDoc.references;
  if (savedObjectsTagging) {
    const tagsIds = persistedDoc && savedObjectsTagging ? savedObjectsTagging.ui.getTagIdsFromReferences(persistedDoc.references) : [];
    references = savedObjectsTagging.ui.updateTagsReferences(references, saveProps.newTags || tagsIds);
  }
  const docToSave = getDocToSave(lastKnownDoc, saveProps, references);

  // Required to serialize filters in by value mode until
  // https://github.com/elastic/kibana/issues/77588 is fixed
  if (getIsByValueMode()) {
    docToSave.state.filters.forEach(filter => {
      if (typeof filter.meta.value === 'function') {
        delete filter.meta.value;
      }
    });
  }
  const originalInput = saveProps.newCopyOnSave ? undefined : initialInput;
  const originalSavedObjectId = originalInput === null || originalInput === void 0 ? void 0 : originalInput.savedObjectId;
  if (options.saveToLibrary) {
    try {
      await (0, _persistence.checkForDuplicateTitle)({
        id: originalSavedObjectId,
        title: docToSave.title,
        displayName: _i18n.i18n.translate('xpack.lens.app.saveModalType', {
          defaultMessage: 'Lens visualization'
        }),
        lastSavedTitle: lastKnownDoc.title,
        copyOnSave: saveProps.newCopyOnSave,
        isTitleDuplicateConfirmed: saveProps.isTitleDuplicateConfirmed
      }, saveProps.onTitleDuplicate, {
        client: savedObjectStore,
        ...startServices
      });
    } catch (e) {
      // ignore duplicate title failure, user notified in save modal
      throw e;
    }
  }
  try {
    let newInput = await attributeService.wrapAttributes(docToSave, options.saveToLibrary, originalInput);
    if (saveProps.panelTimeRange) {
      newInput = {
        ...newInput,
        timeRange: saveProps.panelTimeRange
      };
    }
    if (saveProps.returnToOrigin && redirectToOrigin) {
      // disabling the validation on app leave because the document has been saved.
      onAppLeave === null || onAppLeave === void 0 ? void 0 : onAppLeave(actions => {
        return actions.default();
      });
      redirectToOrigin({
        input: newInput,
        isCopied: saveProps.newCopyOnSave
      });
      return;
    } else if (saveProps.dashboardId) {
      // disabling the validation on app leave because the document has been saved.
      onAppLeave === null || onAppLeave === void 0 ? void 0 : onAppLeave(actions => {
        return actions.default();
      });
      (0, _save_modal_container_helpers.redirectToDashboard)({
        embeddableInput: newInput,
        dashboardId: saveProps.dashboardId,
        stateTransfer,
        originatingApp: props.originatingApp,
        getOriginatingPath: props.getOriginatingPath
      });
      return;
    }
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.lens.app.saveVisualization.successNotificationText', {
      defaultMessage: `Saved ''{visTitle}''`,
      values: {
        visTitle: docToSave.title
      }
    }));
    if (attributeService.inputIsRefType(newInput) && newInput.savedObjectId !== originalSavedObjectId) {
      var _stateTransfer$clearE;
      chrome.recentlyAccessed.add((0, _constants.getFullPath)(newInput.savedObjectId), docToSave.title, newInput.savedObjectId);

      // remove editor state so the connection is still broken after reload
      (_stateTransfer$clearE = stateTransfer.clearEditorState) === null || _stateTransfer$clearE === void 0 ? void 0 : _stateTransfer$clearE.call(stateTransfer, _constants.APP_ID);
      if (textBasedLanguageSave) {
        switchDatasource === null || switchDatasource === void 0 ? void 0 : switchDatasource();
        application.navigateToApp('lens', {
          path: '/'
        });
      } else {
        redirectTo === null || redirectTo === void 0 ? void 0 : redirectTo(newInput.savedObjectId);
      }
      return {
        isLinkedToOriginatingApp: false
      };
    }
    const newDoc = {
      ...docToSave,
      ...newInput
    };
    return {
      persistedDoc: newDoc,
      isLinkedToOriginatingApp: false
    };
  } catch (e) {
    // eslint-disable-next-line no-console
    console.dir(e);
    throw e;
  }
};
exports.runSaveLensVisualization = runSaveLensVisualization;
function removePinnedFilters(doc) {
  var _doc$state;
  if (!doc) return undefined;
  return {
    ...doc,
    state: {
      ...doc.state,
      filters: (((_doc$state = doc.state) === null || _doc$state === void 0 ? void 0 : _doc$state.filters) || []).filter(filter => !(0, _esQuery.isFilterPinned)(filter))
    }
  };
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = SaveModalContainer;