"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isLensEqual = void 0;
var _lodash = require("lodash");
var _save_modal_container = require("./save_modal_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const removeNonSerializable = obj => JSON.parse(JSON.stringify(obj));
const isLensEqual = (doc1In, doc2In, injectFilterReferences, datasourceMap, visualizationMap, annotationGroups) => {
  var _visualizationMap$doc;
  if (doc1In === undefined || doc2In === undefined) {
    return doc1In === doc2In;
  }

  // we do this so that undefined props are the same as non-existant props
  const doc1 = removeNonSerializable(doc1In);
  const doc2 = removeNonSerializable(doc2In);
  if ((doc1 === null || doc1 === void 0 ? void 0 : doc1.visualizationType) !== (doc2 === null || doc2 === void 0 ? void 0 : doc2.visualizationType)) {
    return false;
  }
  if (!(0, _lodash.isEqual)(doc1.state.query, doc2.state.query)) {
    return false;
  }
  const isEqualFromVis = (_visualizationMap$doc = visualizationMap[doc1.visualizationType]) === null || _visualizationMap$doc === void 0 ? void 0 : _visualizationMap$doc.isEqual;
  const visualizationStateIsEqual = isEqualFromVis ? (() => {
    try {
      return isEqualFromVis(doc1.state.visualization, doc1.references, doc2.state.visualization, doc2.references, annotationGroups);
    } catch (err) {
      return false;
    }
  })() : (0, _lodash.isEqual)(doc1.state.visualization, doc2.state.visualization);
  if (!visualizationStateIsEqual) {
    return false;
  }

  // data source equality
  const availableDatasourceTypes1 = Object.keys(doc1.state.datasourceStates);
  const availableDatasourceTypes2 = Object.keys(doc2.state.datasourceStates);
  let datasourcesEqual = (0, _lodash.intersection)(availableDatasourceTypes1, availableDatasourceTypes2).length === (0, _lodash.union)(availableDatasourceTypes1, availableDatasourceTypes2).length;
  if (datasourcesEqual) {
    // equal so far, so actually check
    datasourcesEqual = availableDatasourceTypes1.map(type => datasourceMap[type].isEqual(doc1.state.datasourceStates[type], [...doc1.references, ...(doc1.state.internalReferences || [])], doc2.state.datasourceStates[type], [...doc2.references, ...(doc2.state.internalReferences || [])])).every(res => res);
  }
  if (!datasourcesEqual) {
    return false;
  }
  const [filtersInjected1, filtersInjected2] = [doc1, doc2].map(doc => (0, _save_modal_container.removePinnedFilters)(injectDocFilterReferences(injectFilterReferences, doc)));
  if (!(0, _lodash.isEqual)(filtersInjected1 === null || filtersInjected1 === void 0 ? void 0 : filtersInjected1.state.filters, filtersInjected2 === null || filtersInjected2 === void 0 ? void 0 : filtersInjected2.state.filters)) {
    return false;
  }
  return true;
};
exports.isLensEqual = isLensEqual;
function injectDocFilterReferences(injectFilterReferences, doc) {
  var _doc$state;
  if (!doc) return undefined;
  return {
    ...doc,
    state: {
      ...doc.state,
      filters: injectFilterReferences(((_doc$state = doc.state) === null || _doc$state === void 0 ? void 0 : _doc$state.filters) || [], doc.references)
    }
  };
}