"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToOriginalColumnsTextBased = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapToOriginalColumnsTextBased = (data, {
  idMap: encodedIdMap
}) => {
  const idMap = JSON.parse(encodedIdMap);
  return {
    ...data,
    rows: data.rows.map(row => {
      const mappedRow = {};
      for (const id in row) {
        if (id in idMap) {
          for (const cachedEntry of idMap[id]) {
            mappedRow[cachedEntry.id] = row[id]; // <= I wrote idMap rather than mappedRow
          }
        }
      }
      return mappedRow;
    }),
    columns: data.columns.flatMap(column => {
      if (!(column.id in idMap)) {
        return [];
      }
      return idMap[column.id].map(originalColumn => ({
        ...column,
        id: originalColumn.id
      }));
    })
  };
};
exports.mapToOriginalColumnsTextBased = mapToOriginalColumnsTextBased;