"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldMetaFromDatatable = getFieldMetaFromDatatable;
exports.isNumericField = isNumericField;
exports.isNumericFieldForDatatable = isNumericFieldForDatatable;
var _transpose_helpers = require("./transpose_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns true for numerical fields
 *
 * Excludes the following types:
 *  - `range` - Stringified range
 *  - `multi_terms` - Multiple values
 *  - `filters` - Arbitrary label
 *  - `filtered_metric` - Array of values
 */
function isNumericField(meta) {
  var _meta$params, _meta$params2, _meta$sourceParams, _meta$sourceParams2;
  return (meta === null || meta === void 0 ? void 0 : meta.type) === 'number' && ((_meta$params = meta.params) === null || _meta$params === void 0 ? void 0 : _meta$params.id) !== 'range' && ((_meta$params2 = meta.params) === null || _meta$params2 === void 0 ? void 0 : _meta$params2.id) !== 'multi_terms' && ((_meta$sourceParams = meta.sourceParams) === null || _meta$sourceParams === void 0 ? void 0 : _meta$sourceParams.type) !== 'filters' && ((_meta$sourceParams2 = meta.sourceParams) === null || _meta$sourceParams2 === void 0 ? void 0 : _meta$sourceParams2.type) !== 'filtered_metric';
}

/**
 * Returns true for numerical fields, excluding ranges
 */
function isNumericFieldForDatatable(table, accessor) {
  const meta = getFieldMetaFromDatatable(table, accessor);
  return isNumericField(meta);
}
function getFieldMetaFromDatatable(table, accessor) {
  var _table$columns$find;
  return table === null || table === void 0 ? void 0 : (_table$columns$find = table.columns.find(col => col.id === accessor || (0, _transpose_helpers.getOriginalId)(col.id) === accessor)) === null || _table$columns$find === void 0 ? void 0 : _table$columns$find.meta;
}