"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PieChartTypes = exports.PLUGIN_ID = exports.NumberDisplay = exports.NOT_INTERNATIONALIZED_PRODUCT_NAME = exports.LegendDisplay = exports.LENS_EMBEDDABLE_TYPE = exports.LENS_EDIT_BY_VALUE = exports.LENS_APP_NAME = exports.DOC_TYPE = exports.DOCUMENT_FIELD_NAME = exports.CategoryDisplay = exports.COLOR_MAPPING_OFF_BY_DEFAULT = exports.BASE_API_URL = exports.APP_ID = void 0;
exports.getBasePath = getBasePath;
exports.getEditPath = getEditPath;
exports.getFullPath = getFullPath;
var _rison = _interopRequireDefault(require("@kbn/rison"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'lens';
const APP_ID = exports.APP_ID = 'lens';
const LENS_APP_NAME = exports.LENS_APP_NAME = 'lens';
const LENS_EMBEDDABLE_TYPE = exports.LENS_EMBEDDABLE_TYPE = 'lens';
const DOC_TYPE = exports.DOC_TYPE = 'lens';
const NOT_INTERNATIONALIZED_PRODUCT_NAME = exports.NOT_INTERNATIONALIZED_PRODUCT_NAME = 'Lens Visualizations';
const BASE_API_URL = exports.BASE_API_URL = '/api/lens';
const LENS_EDIT_BY_VALUE = exports.LENS_EDIT_BY_VALUE = 'edit_by_value';
const PieChartTypes = exports.PieChartTypes = {
  PIE: 'pie',
  DONUT: 'donut',
  TREEMAP: 'treemap',
  MOSAIC: 'mosaic',
  WAFFLE: 'waffle'
};
const CategoryDisplay = exports.CategoryDisplay = {
  DEFAULT: 'default',
  INSIDE: 'inside',
  HIDE: 'hide'
};
const NumberDisplay = exports.NumberDisplay = {
  HIDDEN: 'hidden',
  PERCENT: 'percent',
  VALUE: 'value'
};
const LegendDisplay = exports.LegendDisplay = {
  DEFAULT: 'default',
  SHOW: 'show',
  HIDE: 'hide'
};

// might collide with user-supplied field names, try to make as unique as possible
const DOCUMENT_FIELD_NAME = exports.DOCUMENT_FIELD_NAME = '___records___';
function getBasePath() {
  return `#/`;
}
const GLOBAL_RISON_STATE_PARAM = '_g';
function getEditPath(id, timeRange, filters, refreshInterval) {
  const searchArgs = {};
  if (timeRange) {
    searchArgs.time = timeRange;
  }
  if (filters) {
    searchArgs.filters = filters;
  }
  if (refreshInterval) {
    searchArgs.refreshInterval = refreshInterval;
  }
  const searchParam = Object.keys(searchArgs).length ? `?${GLOBAL_RISON_STATE_PARAM}=${_rison.default.encode(searchArgs)}` : '';
  return id ? `#/edit/${encodeURIComponent(id)}${searchParam}` : `#/${LENS_EDIT_BY_VALUE}${searchParam}`;
}
function getFullPath(id) {
  return `/app/${PLUGIN_ID}${id ? getEditPath(id) : getBasePath()}`;
}
const COLOR_MAPPING_OFF_BY_DEFAULT = exports.COLOR_MAPPING_OFF_BY_DEFAULT = false;