"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryTracer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _base = require("@langchain/core/tracers/base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * TelemetryTracer is a tracer that uses event based telemetry to track LangChain events.
 */
class TelemetryTracer extends _base.BaseTracer {
  constructor(fields, logger) {
    super(fields);
    (0, _defineProperty2.default)(this, "name", 'telemetry_tracer');
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "elasticTools", void 0);
    (0, _defineProperty2.default)(this, "telemetry", void 0);
    (0, _defineProperty2.default)(this, "telemetryParams", void 0);
    (0, _defineProperty2.default)(this, "totalTools", void 0);
    this.logger = logger.get('telemetryTracer');
    this.elasticTools = fields.elasticTools;
    this.telemetry = fields.telemetry;
    this.telemetryParams = fields.telemetryParams;
    this.totalTools = fields.totalTools;
  }
  async onChainEnd(run) {
    if (!run.parent_run_id) {
      var _run$end_time, _run$start_time;
      const {
        eventType,
        ...telemetryParams
      } = this.telemetryParams;
      const toolsInvoked = run !== null && run !== void 0 && run.outputs && run !== null && run !== void 0 && run.outputs.steps.length ? run.outputs.steps.reduce((acc, event) => {
        var _event$action;
        if ('action' in event && event !== null && event !== void 0 && (_event$action = event.action) !== null && _event$action !== void 0 && _event$action.tool) {
          if (this.elasticTools.includes(event.action.tool)) {
            return {
              ...acc,
              ...(event.action.tool in acc ? {
                [event.action.tool]: acc[event.action.tool] + 1
              } : {
                [event.action.tool]: 1
              })
            };
          } else {
            // Custom tool names are user data, so we strip them out
            return {
              ...acc,
              ...('CustomTool' in acc ? {
                CustomTool: acc.CustomTool + 1
              } : {
                CustomTool: 1
              })
            };
          }
        }
        return acc;
      }, {}) : {};
      const telemetryValue = {
        ...telemetryParams,
        durationMs: ((_run$end_time = run.end_time) !== null && _run$end_time !== void 0 ? _run$end_time : 0) - ((_run$start_time = run.start_time) !== null && _run$start_time !== void 0 ? _run$start_time : 0),
        toolsInvoked,
        ...(telemetryParams.actionTypeId === '.gen-ai' ? {
          isOssModel: run.inputs.isOssModel
        } : {})
      };
      this.logger.debug(() => `Invoke ${eventType} telemetry:\n${JSON.stringify(telemetryValue, null, 2)}`);
      this.telemetry.reportEvent(eventType, telemetryValue);
    }
  }

  // everything below is required for type only
  async persistRun(_run) {}
}
exports.TelemetryTracer = TelemetryTracer;