"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsClientGeminiChatModel = void 0;
var _googleGenai = require("@langchain/google-genai");
var _fp = require("lodash/fp");
var _gemini = require("../utils/gemini");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_GEMINI_TEMPERATURE = 0;
var _actionsClient = /*#__PURE__*/new WeakMap();
var _connectorId = /*#__PURE__*/new WeakMap();
var _temperature = /*#__PURE__*/new WeakMap();
var _model = /*#__PURE__*/new WeakMap();
class ActionsClientGeminiChatModel extends _googleGenai.ChatGoogleGenerativeAI {
  constructor({
    actionsClient,
    connectorId,
    ...props
  }) {
    var _props$maxTokens, _props$model, _props$temperature;
    super({
      ...props,
      apiKey: 'asda',
      maxOutputTokens: (_props$maxTokens = props.maxTokens) !== null && _props$maxTokens !== void 0 ? _props$maxTokens : 2048
    });
    // LangChain needs model to be defined for logging purposes
    _classPrivateFieldInitSpec(this, _actionsClient, void 0);
    _classPrivateFieldInitSpec(this, _connectorId, void 0);
    _classPrivateFieldInitSpec(this, _temperature, void 0);
    _classPrivateFieldInitSpec(this, _model, void 0);
    this.model = (_props$model = props.model) !== null && _props$model !== void 0 ? _props$model : this.model;
    // If model is not specified by consumer, the connector will defin eit so do not pass
    // a LangChain default to the actionsClient
    _classPrivateFieldSet(_model, this, props.model);
    _classPrivateFieldSet(_temperature, this, (_props$temperature = props.temperature) !== null && _props$temperature !== void 0 ? _props$temperature : DEFAULT_GEMINI_TEMPERATURE);
    _classPrivateFieldSet(_actionsClient, this, actionsClient);
    _classPrivateFieldSet(_connectorId, this, connectorId);
  }
  async completionWithRetry(request, options) {
    return this.caller.callWithOptions({
      signal: options === null || options === void 0 ? void 0 : options.signal
    }, async () => {
      try {
        const requestBody = {
          actionId: _classPrivateFieldGet(_connectorId, this),
          params: {
            subAction: 'invokeAIRaw',
            subActionParams: {
              model: _classPrivateFieldGet(_model, this),
              messages: request.contents,
              tools: request.tools,
              temperature: _classPrivateFieldGet(_temperature, this)
            }
          }
        };
        const actionResult = await _classPrivateFieldGet(_actionsClient, this).execute(requestBody);
        if (actionResult.status === 'error') {
          const error = new Error(`ActionsClientGeminiChatModel: action result status is error: ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.message} - ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage}`);
          if (actionResult !== null && actionResult !== void 0 && actionResult.serviceMessage) {
            error.name = actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage;
          }
          throw error;
        }
        if (actionResult.data.candidates && actionResult.data.candidates.length > 0) {
          // handle bad finish reason
          const errorMessage = (0, _gemini.convertResponseBadFinishReasonToErrorMsg)(actionResult.data);
          if (errorMessage != null) {
            throw new Error(errorMessage);
          }
        }
        return {
          response: {
            ...actionResult.data,
            functionCalls: () => {
              var _actionResult$data, _actionResult$data$ca, _actionResult$data$ca2, _actionResult$data$ca3, _actionResult$data2, _actionResult$data2$c, _actionResult$data2$c2;
              return (_actionResult$data = actionResult.data) !== null && _actionResult$data !== void 0 && (_actionResult$data$ca = _actionResult$data.candidates) !== null && _actionResult$data$ca !== void 0 && (_actionResult$data$ca2 = _actionResult$data$ca[0]) !== null && _actionResult$data$ca2 !== void 0 && (_actionResult$data$ca3 = _actionResult$data$ca2.content) !== null && _actionResult$data$ca3 !== void 0 && _actionResult$data$ca3.parts[0].functionCall ? [(_actionResult$data2 = actionResult.data) === null || _actionResult$data2 === void 0 ? void 0 : (_actionResult$data2$c = _actionResult$data2.candidates) === null || _actionResult$data2$c === void 0 ? void 0 : (_actionResult$data2$c2 = _actionResult$data2$c[0]) === null || _actionResult$data2$c2 === void 0 ? void 0 : _actionResult$data2$c2.content.parts[0].functionCall] : [];
            }
          }
        };
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
      } catch (e) {
        var _e$message;
        // TODO: Improve error handling
        if ((_e$message = e.message) !== null && _e$message !== void 0 && _e$message.includes('400 Bad Request')) {
          e.status = 400;
        }
        throw e;
      }
    });
  }
  async *_streamResponseChunks(messages, options, runManager) {
    const prompt = (0, _gemini.convertBaseMessagesToContent)(messages, this._isMultimodalModel);
    const parameters = this.invocationParams(options);
    const request = {
      ...parameters,
      contents: prompt
    };
    const stream = await this.caller.callWithOptions({
      signal: options === null || options === void 0 ? void 0 : options.signal
    }, async () => {
      const requestBody = {
        actionId: _classPrivateFieldGet(_connectorId, this),
        params: {
          subAction: 'invokeStream',
          subActionParams: {
            model: _classPrivateFieldGet(_model, this),
            messages: request.contents.reduce((acc, item) => {
              if (!(acc !== null && acc !== void 0 && acc.length)) {
                acc.push(item);
                return acc;
              }
              if (acc[acc.length - 1].role === item.role) {
                acc[acc.length - 1].parts = acc[acc.length - 1].parts.concat(item.parts);
                return acc;
              }
              acc.push(item);
              return acc;
            }, []),
            temperature: _classPrivateFieldGet(_temperature, this),
            tools: request.tools
          }
        }
      };
      const actionResult = await _classPrivateFieldGet(_actionsClient, this).execute(requestBody);
      if (actionResult.status === 'error') {
        const error = new Error(`ActionsClientGeminiChatModel: action result status is error: ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.message} - ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage}`);
        if (actionResult !== null && actionResult !== void 0 && actionResult.serviceMessage) {
          error.name = actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage;
        }
        throw error;
      }
      const readable = (0, _fp.get)('data', actionResult);
      if (typeof (readable === null || readable === void 0 ? void 0 : readable.read) !== 'function') {
        throw new Error('Action result status is error: result is not streamable');
      }
      return readable;
    });
    let usageMetadata;
    let index = 0;
    let partialStreamChunk = '';
    for await (const rawStreamChunk of stream) {
      const streamChunk = rawStreamChunk.toString();
      const nextChunk = `${partialStreamChunk + streamChunk}`;
      let parsedStreamChunk = null;
      try {
        parsedStreamChunk = JSON.parse(nextChunk.replaceAll('data: ', '').replaceAll('\r\n', ''));
        partialStreamChunk = '';
      } catch (_) {
        partialStreamChunk += nextChunk;
      }
      if (parsedStreamChunk !== null) {
        const errorMessage = (0, _gemini.convertResponseBadFinishReasonToErrorMsg)(parsedStreamChunk);
        if (errorMessage != null) {
          throw new Error(errorMessage);
        }
        const response = {
          ...parsedStreamChunk,
          functionCalls: () => {
            var _parsedStreamChunk, _parsedStreamChunk$ca, _parsedStreamChunk$ca2, _parsedStreamChunk$ca3, _parsedStreamChunk$ca4;
            return (_parsedStreamChunk = parsedStreamChunk) !== null && _parsedStreamChunk !== void 0 && (_parsedStreamChunk$ca = _parsedStreamChunk.candidates) !== null && _parsedStreamChunk$ca !== void 0 && (_parsedStreamChunk$ca2 = _parsedStreamChunk$ca[0]) !== null && _parsedStreamChunk$ca2 !== void 0 && _parsedStreamChunk$ca2.content.parts[0].functionCall ? [(_parsedStreamChunk$ca3 = parsedStreamChunk.candidates) === null || _parsedStreamChunk$ca3 === void 0 ? void 0 : (_parsedStreamChunk$ca4 = _parsedStreamChunk$ca3[0]) === null || _parsedStreamChunk$ca4 === void 0 ? void 0 : _parsedStreamChunk$ca4.content.parts[0].functionCall] : [];
          }
        };
        if ('usageMetadata' in response && this.streamUsage !== false && options.streamUsage !== false) {
          const genAIUsageMetadata = response.usageMetadata;
          if (!usageMetadata) {
            usageMetadata = {
              input_tokens: genAIUsageMetadata.promptTokenCount,
              output_tokens: genAIUsageMetadata.candidatesTokenCount,
              total_tokens: genAIUsageMetadata.totalTokenCount
            };
          } else {
            // Under the hood, LangChain combines the prompt tokens. Google returns the updated
            // total each time, so we need to find the difference between the tokens.
            const outputTokenDiff = genAIUsageMetadata.candidatesTokenCount - usageMetadata.output_tokens;
            usageMetadata = {
              input_tokens: 0,
              output_tokens: outputTokenDiff,
              total_tokens: outputTokenDiff
            };
          }
        }
        const chunk = (0, _gemini.convertResponseContentToChatGenerationChunk)(response, {
          usageMetadata,
          index
        });
        index += 1;
        if (chunk) {
          var _chunk$text;
          yield chunk;
          await (runManager === null || runManager === void 0 ? void 0 : runManager.handleLLMNewToken((_chunk$text = chunk.text) !== null && _chunk$text !== void 0 ? _chunk$text : ''));
        }
      }
    }
  }
}
exports.ActionsClientGeminiChatModel = ActionsClientGeminiChatModel;