"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsClientChatConnection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _googleCommon = require("@langchain/google-common");
var _gemini = require("../../utils/gemini");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// only implements non-streaming requests
// stream is handled by ActionsClientChatVertexAI.*_streamResponseChunks
var _model = /*#__PURE__*/new WeakMap();
class ActionsClientChatConnection extends _googleCommon.ChatConnection {
  constructor(fields, caller, client, _streaming,
  // defaulting to false in the super
  actionsClient, connectorId) {
    var _fields$temperature;
    super(fields, caller, client, false);
    (0, _defineProperty2.default)(this, "actionsClient", void 0);
    (0, _defineProperty2.default)(this, "connectorId", void 0);
    _classPrivateFieldInitSpec(this, _model, void 0);
    (0, _defineProperty2.default)(this, "temperature", void 0);
    (0, _defineProperty2.default)(this, "caller", void 0);
    this.actionsClient = actionsClient;
    this.connectorId = connectorId;
    this.caller = caller;
    _classPrivateFieldSet(_model, this, fields.model);
    this.temperature = (_fields$temperature = fields.temperature) !== null && _fields$temperature !== void 0 ? _fields$temperature : 0;
    const nativeFormatData = this.formatData.bind(this);
    this.formatData = async (data, options) => {
      const result = await nativeFormatData(data, options);
      if ((result === null || result === void 0 ? void 0 : result.contents) != null && result !== null && result !== void 0 && result.contents.length) {
        // ensure there are not 2 messages in a row from the same role,
        // if there are combine them
        result.contents = result.contents.reduce((acc, currentEntry) => {
          var _acc;
          if (currentEntry.role === ((_acc = acc[acc.length - 1]) === null || _acc === void 0 ? void 0 : _acc.role)) {
            acc[acc.length - 1].parts = acc[acc.length - 1].parts.concat(currentEntry.parts);
            return acc;
          }
          return [...acc, currentEntry];
        }, []);
      }
      return result;
    };
  }
  async _request(
  // TODO better types here
  data, options) {
    var _data$systemInstructi, _data$systemInstructi2, _data$systemInstructi3, _data$systemInstructi4, _data$systemInstructi5, _data$systemInstructi6;
    const systemInstruction = data !== null && data !== void 0 && (_data$systemInstructi = data.systemInstruction) !== null && _data$systemInstructi !== void 0 && (_data$systemInstructi2 = _data$systemInstructi.parts) !== null && _data$systemInstructi2 !== void 0 && (_data$systemInstructi3 = _data$systemInstructi2[0]) !== null && _data$systemInstructi3 !== void 0 && _data$systemInstructi3.text.length ? {
      systemInstruction: data === null || data === void 0 ? void 0 : (_data$systemInstructi4 = data.systemInstruction) === null || _data$systemInstructi4 === void 0 ? void 0 : (_data$systemInstructi5 = _data$systemInstructi4.parts) === null || _data$systemInstructi5 === void 0 ? void 0 : (_data$systemInstructi6 = _data$systemInstructi5[0]) === null || _data$systemInstructi6 === void 0 ? void 0 : _data$systemInstructi6.text
    } : {};
    return this.caller.callWithOptions({
      signal: options === null || options === void 0 ? void 0 : options.signal
    }, async () => {
      try {
        const requestBody = {
          actionId: this.connectorId,
          params: {
            subAction: 'invokeAIRaw',
            subActionParams: {
              model: _classPrivateFieldGet(_model, this),
              messages: data === null || data === void 0 ? void 0 : data.contents,
              tools: data === null || data === void 0 ? void 0 : data.tools,
              temperature: this.temperature,
              ...systemInstruction
            }
          }
        };
        const actionResult = await this.actionsClient.execute(requestBody);
        if (actionResult.status === 'error') {
          const error = new Error(`ActionsClientChatVertexAI: action result status is error: ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.message} - ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage}`);
          if (actionResult !== null && actionResult !== void 0 && actionResult.serviceMessage) {
            error.name = actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage;
          }
          throw error;
        }
        if (actionResult.data.candidates && actionResult.data.candidates.length > 0) {
          // handle bad finish reason
          const errorMessage = (0, _gemini.convertResponseBadFinishReasonToErrorMsg)(actionResult.data);
          if (errorMessage != null) {
            throw new Error(errorMessage);
          }
        }
        return actionResult;
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
      } catch (e) {
        var _e$message;
        // TODO: Improve error handling
        if ((_e$message = e.message) !== null && _e$message !== void 0 && _e$message.includes('400 Bad Request')) {
          e.status = 400;
        }
        throw e;
      }
    });
  }
}
exports.ActionsClientChatConnection = ActionsClientChatConnection;