"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsClientChatVertexAI = void 0;
var _googleVertexai = require("@langchain/google-vertexai");
var _fp = require("lodash/fp");
var _gemini = require("../../utils/gemini");
var _connection = require("./connection");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_GEMINI_TEMPERATURE = 0;
var _actionsClient = /*#__PURE__*/new WeakMap();
var _connectorId = /*#__PURE__*/new WeakMap();
var _model = /*#__PURE__*/new WeakMap();
class ActionsClientChatVertexAI extends _googleVertexai.ChatVertexAI {
  constructor({
    actionsClient,
    connectorId,
    ...props
  }) {
    var _props$maxTokens, _props$temperature, _props$model;
    super({
      ...props,
      maxOutputTokens: (_props$maxTokens = props.maxTokens) !== null && _props$maxTokens !== void 0 ? _props$maxTokens : 2048,
      temperature: (_props$temperature = props.temperature) !== null && _props$temperature !== void 0 ? _props$temperature : DEFAULT_GEMINI_TEMPERATURE
    });
    // LangChain needs model to be defined for logging purposes
    _classPrivateFieldInitSpec(this, _actionsClient, void 0);
    _classPrivateFieldInitSpec(this, _connectorId, void 0);
    _classPrivateFieldInitSpec(this, _model, void 0);
    this.model = (_props$model = props.model) !== null && _props$model !== void 0 ? _props$model : this.model;
    // If model is not specified by consumer, the connector will define it so do not pass
    // a LangChain default to the actionsClient
    _classPrivateFieldSet(_model, this, props.model);
    _classPrivateFieldSet(_actionsClient, this, actionsClient);
    _classPrivateFieldSet(_connectorId, this, connectorId);
    const client = this.buildClient(props);
    this.connection = new _connection.ActionsClientChatConnection({
      ...this
    }, this.caller, client, false, actionsClient, connectorId);
  }
  buildConnection() {
    // prevent ChatVertexAI from overwriting our this.connection defined in super
  }
  async *_streamResponseChunks(messages, options, runManager) {
    const parameters = this.invocationParams(options);
    const data = await this.connection.formatData(messages, parameters);
    const stream = await this.caller.callWithOptions({
      signal: options === null || options === void 0 ? void 0 : options.signal
    }, async () => {
      var _data$systemInstructi, _data$systemInstructi2;
      const systemPart = data === null || data === void 0 ? void 0 : (_data$systemInstructi = data.systemInstruction) === null || _data$systemInstructi === void 0 ? void 0 : (_data$systemInstructi2 = _data$systemInstructi.parts) === null || _data$systemInstructi2 === void 0 ? void 0 : _data$systemInstructi2[0];
      const systemInstruction = systemPart !== null && systemPart !== void 0 && systemPart.text.length ? {
        systemInstruction: systemPart === null || systemPart === void 0 ? void 0 : systemPart.text
      } : {};
      const requestBody = {
        actionId: _classPrivateFieldGet(_connectorId, this),
        params: {
          subAction: 'invokeStream',
          subActionParams: {
            model: _classPrivateFieldGet(_model, this),
            messages: data === null || data === void 0 ? void 0 : data.contents,
            tools: data === null || data === void 0 ? void 0 : data.tools,
            temperature: this.temperature,
            ...systemInstruction
          }
        }
      };
      const actionResult = await _classPrivateFieldGet(_actionsClient, this).execute(requestBody);
      if (actionResult.status === 'error') {
        const error = new Error(`ActionsClientChatVertexAI: action result status is error: ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.message} - ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage}`);
        if (actionResult !== null && actionResult !== void 0 && actionResult.serviceMessage) {
          error.name = actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage;
        }
        throw error;
      }
      const readable = (0, _fp.get)('data', actionResult);
      if (typeof (readable === null || readable === void 0 ? void 0 : readable.read) !== 'function') {
        throw new Error('Action result status is error: result is not streamable');
      }
      return readable;
    });
    let usageMetadata;
    let index = 0;
    let partialStreamChunk = '';
    for await (const rawStreamChunk of stream) {
      const streamChunk = rawStreamChunk.toString();
      const nextChunk = `${partialStreamChunk + streamChunk}`;
      let parsedStreamChunk = null;
      try {
        parsedStreamChunk = JSON.parse(nextChunk.replaceAll('data: ', '').replaceAll('\r\n', ''));
        partialStreamChunk = '';
      } catch (_) {
        partialStreamChunk += nextChunk;
      }
      if (parsedStreamChunk !== null) {
        const errorMessage = (0, _gemini.convertResponseBadFinishReasonToErrorMsg)(parsedStreamChunk);
        if (errorMessage != null) {
          throw new Error(errorMessage);
        }
        const response = {
          ...parsedStreamChunk,
          functionCalls: () => {
            var _parsedStreamChunk, _parsedStreamChunk$ca, _parsedStreamChunk$ca2, _parsedStreamChunk$ca3, _parsedStreamChunk$ca4;
            return (_parsedStreamChunk = parsedStreamChunk) !== null && _parsedStreamChunk !== void 0 && (_parsedStreamChunk$ca = _parsedStreamChunk.candidates) !== null && _parsedStreamChunk$ca !== void 0 && (_parsedStreamChunk$ca2 = _parsedStreamChunk$ca[0]) !== null && _parsedStreamChunk$ca2 !== void 0 && _parsedStreamChunk$ca2.content.parts[0].functionCall ? [(_parsedStreamChunk$ca3 = parsedStreamChunk.candidates) === null || _parsedStreamChunk$ca3 === void 0 ? void 0 : (_parsedStreamChunk$ca4 = _parsedStreamChunk$ca3[0]) === null || _parsedStreamChunk$ca4 === void 0 ? void 0 : _parsedStreamChunk$ca4.content.parts[0].functionCall] : [];
          }
        };
        if ('usageMetadata' in response && this.streamUsage !== false && options.streamUsage !== false) {
          const genAIUsageMetadata = response.usageMetadata;
          if (!usageMetadata) {
            usageMetadata = {
              input_tokens: genAIUsageMetadata.promptTokenCount,
              output_tokens: genAIUsageMetadata.candidatesTokenCount,
              total_tokens: genAIUsageMetadata.totalTokenCount
            };
          } else {
            // Under the hood, LangChain combines the prompt tokens. Google returns the updated
            // total each time, so we need to find the difference between the tokens.
            const outputTokenDiff = genAIUsageMetadata.candidatesTokenCount - usageMetadata.output_tokens;
            usageMetadata = {
              input_tokens: 0,
              output_tokens: outputTokenDiff,
              total_tokens: outputTokenDiff
            };
          }
        }
        const chunk = (0, _gemini.convertResponseContentToChatGenerationChunk)(response, {
          usageMetadata,
          index
        });
        index += 1;
        if (chunk) {
          var _chunk$text;
          yield chunk;
          await (runManager === null || runManager === void 0 ? void 0 : runManager.handleLLMNewToken((_chunk$text = chunk.text) !== null && _chunk$text !== void 0 ? _chunk$text : ''));
        }
      }
    }
  }
}
exports.ActionsClientChatVertexAI = ActionsClientChatVertexAI;