"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_BEDROCK_REGION = exports.DEFAULT_BEDROCK_MODEL = exports.ActionsClientBedrockChatModel = void 0;
var _web = require("@langchain/community/chat_models/bedrock/web");
var _stream = require("stream");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_BEDROCK_MODEL = exports.DEFAULT_BEDROCK_MODEL = 'anthropic.claude-3-5-sonnet-20240620-v1:0';
const DEFAULT_BEDROCK_REGION = exports.DEFAULT_BEDROCK_REGION = 'us-east-1';
class ActionsClientBedrockChatModel extends _web.BedrockChat {
  constructor({
    actionsClient,
    connectorId,
    logger,
    ...params
  }) {
    var _params$model;
    super({
      ...params,
      credentials: {
        accessKeyId: '',
        secretAccessKey: ''
      },
      // only needed to force BedrockChat to use messages api for Claude v2
      model: (_params$model = params.model) !== null && _params$model !== void 0 ? _params$model : DEFAULT_BEDROCK_MODEL,
      region: DEFAULT_BEDROCK_REGION,
      fetchFn: async (url, options) => {
        var _inputBody$tools, _params$temperature2, _params$maxTokens2;
        const inputBody = JSON.parse(options === null || options === void 0 ? void 0 : options.body);
        if (this.streaming && !((_inputBody$tools = inputBody.tools) !== null && _inputBody$tools !== void 0 && _inputBody$tools.length)) {
          var _params$temperature, _params$maxTokens;
          const data = await actionsClient.execute({
            actionId: connectorId,
            params: {
              subAction: 'invokeStream',
              subActionParams: {
                messages: inputBody.messages,
                temperature: (_params$temperature = params.temperature) !== null && _params$temperature !== void 0 ? _params$temperature : inputBody.temperature,
                stopSequences: inputBody.stop_sequences,
                system: inputBody.system,
                maxTokens: (_params$maxTokens = params.maxTokens) !== null && _params$maxTokens !== void 0 ? _params$maxTokens : inputBody.max_tokens,
                tools: inputBody.tools,
                anthropicVersion: inputBody.anthropic_version
              }
            }
          });
          if (data.status === 'error') {
            throw new Error(`ActionsClientBedrockChat: action result status is error: ${data === null || data === void 0 ? void 0 : data.message} - ${data === null || data === void 0 ? void 0 : data.serviceMessage}`);
          }
          return {
            body: _stream.Readable.toWeb(data.data)
          };
        }
        const data = await actionsClient.execute({
          actionId: connectorId,
          params: {
            subAction: 'invokeAIRaw',
            subActionParams: {
              messages: prepareMessages(inputBody.messages),
              temperature: (_params$temperature2 = params.temperature) !== null && _params$temperature2 !== void 0 ? _params$temperature2 : inputBody.temperature,
              stopSequences: inputBody.stop_sequences,
              system: inputBody.system,
              maxTokens: (_params$maxTokens2 = params.maxTokens) !== null && _params$maxTokens2 !== void 0 ? _params$maxTokens2 : inputBody.max_tokens,
              tools: inputBody.tools,
              anthropicVersion: inputBody.anthropic_version
            }
          }
        });
        if (data.status === 'error') {
          throw new Error(`ActionsClientBedrockChat: action result status is error: ${data === null || data === void 0 ? void 0 : data.message} - ${data === null || data === void 0 ? void 0 : data.serviceMessage}`);
        }
        return {
          ok: data.status === 'ok',
          json: () => data.data
        };
      }
    });
  }
}
exports.ActionsClientBedrockChatModel = ActionsClientBedrockChatModel;
const prepareMessages = messages => messages.reduce((acc, {
  role,
  content
}) => {
  const lastMessage = acc[acc.length - 1];
  if (!lastMessage || lastMessage.role !== role) {
    acc.push({
      role,
      content
    });
    return acc;
  }
  if (lastMessage.role === role) {
    acc[acc.length - 1].content = lastMessage.content.concat(content);
    return acc;
  }
  return acc;
}, []);