"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showBreadcrumbDisplayText = void 0;
var _types = require("../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const showBreadcrumbDisplayText = (treeNavSelection, collectionType) => {
  const resourceNames = Object.keys(treeNavSelection);
  const lastSelectedResourceName = resourceNames[resourceNames.length - 1];
  const isClusterNameSelected = lastSelectedResourceName === _types.KubernetesTreeViewLevels.clusterName && collectionType === _types.KubernetesTreeViewLevels.clusterId;
  const isLastSelectedCollectionType = collectionType === lastSelectedResourceName;
  return isClusterNameSelected || isLastSelectedCollectionType;
};
exports.showBreadcrumbDisplayText = showBreadcrumbDisplayText;