"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statusSchema = exports.investigationSchema = void 0;
var _zod = require("@kbn/zod");
var _origin = require("./origin");
var _investigation_note = require("./investigation_note");
var _investigation_item = require("./investigation_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const statusSchema = exports.statusSchema = _zod.z.union([_zod.z.literal('triage'), _zod.z.literal('active'), _zod.z.literal('mitigated'), _zod.z.literal('resolved'), _zod.z.literal('cancelled')]);
const investigationSchema = exports.investigationSchema = _zod.z.object({
  id: _zod.z.string(),
  title: _zod.z.string(),
  createdAt: _zod.z.number(),
  createdBy: _zod.z.string(),
  updatedAt: _zod.z.number(),
  params: _zod.z.object({
    timeRange: _zod.z.object({
      from: _zod.z.number(),
      to: _zod.z.number()
    })
  }),
  origin: _zod.z.union([_origin.alertOriginSchema, _origin.blankOriginSchema]),
  status: statusSchema,
  tags: _zod.z.array(_zod.z.string()),
  notes: _zod.z.array(_investigation_note.investigationNoteSchema),
  items: _zod.z.array(_investigation_item.investigationItemSchema),
  externalIncidentUrl: _zod.z.string().nullable()
});