"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const eventTypeSchema = _zod.z.union([_zod.z.literal('annotation'), _zod.z.literal('alert'), _zod.z.literal('error_rate'), _zod.z.literal('latency'), _zod.z.literal('anomaly')]);
const annotationEventSchema = _zod.z.object({
  eventType: _zod.z.literal('annotation'),
  annotationType: _zod.z.string().optional()
});
const alertStatusSchema = _zod.z.union([_zod.z.literal('active'), _zod.z.literal('flapping'), _zod.z.literal('recovered'), _zod.z.literal('untracked')]);
const alertEventSchema = _zod.z.object({
  eventType: _zod.z.literal('alert'),
  alertStatus: alertStatusSchema
});
const sourceSchema = _zod.z.record(_zod.z.string(), _zod.z.any());
const eventSchema = exports.eventSchema = _zod.z.intersection(_zod.z.object({
  id: _zod.z.string(),
  title: _zod.z.string(),
  description: _zod.z.string(),
  timestamp: _zod.z.number(),
  eventType: eventTypeSchema,
  source: sourceSchema.optional()
}), _zod.z.discriminatedUnion('eventType', [annotationEventSchema, alertEventSchema]));