"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEventsResponseSchema = exports.getEventsParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _event = require("./event");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getEventsParamsSchema = exports.getEventsParamsSchema = _zod.z.object({
  query: _zod.z.object({
    rangeFrom: _zod.z.string(),
    rangeTo: _zod.z.string(),
    filter: _zod.z.string()
  }).partial()
}).partial();
const getEventsResponseSchema = exports.getEventsResponseSchema = _zod.z.array(_event.eventResponseSchema);