"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInvestigationResponseSchema = exports.createInvestigationParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _investigation = require("./investigation");
var _schema = require("../schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createInvestigationParamsSchema = exports.createInvestigationParamsSchema = _zod.z.object({
  body: _zod.z.object({
    id: _zod.z.string(),
    title: _zod.z.string(),
    params: _zod.z.object({
      timeRange: _zod.z.object({
        from: _zod.z.number(),
        to: _zod.z.number()
      })
    }),
    origin: _zod.z.union([_schema.alertOriginSchema, _schema.blankOriginSchema]),
    tags: _zod.z.array(_zod.z.string()),
    externalIncidentUrl: _zod.z.string().nullable()
  })
});
const createInvestigationResponseSchema = exports.createInvestigationResponseSchema = _investigation.investigationResponseSchema;