"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteInvestigationItem = deleteInvestigationItem;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteInvestigationItem(investigationId, itemId, {
  repository,
  user
}) {
  const investigation = await repository.findById(investigationId);
  const item = investigation.items.find(currItem => currItem.id === itemId);
  if (!item) {
    throw new Error('Item not found');
  }
  if (item.createdBy !== user.profile_uid) {
    throw new Error('User does not have permission to delete item');
  }
  investigation.items = investigation.items.filter(currItem => currItem.id !== itemId);
  await repository.save(investigation);
}