"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.investigation = exports.SO_INVESTIGATION_TYPE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SO_INVESTIGATION_TYPE = exports.SO_INVESTIGATION_TYPE = 'investigation';
const investigation = exports.investigation = {
  name: SO_INVESTIGATION_TYPE,
  hidden: false,
  namespaceType: 'multiple-isolated',
  mappings: {
    dynamic: false,
    properties: {
      id: {
        type: 'keyword'
      },
      title: {
        type: 'text'
      },
      origin: {
        properties: {
          type: {
            type: 'keyword'
          },
          id: {
            type: 'keyword'
          }
        }
      },
      status: {
        type: 'keyword'
      },
      tags: {
        type: 'keyword'
      }
    }
  },
  management: {
    displayName: 'Investigation',
    importableAndExportable: false,
    getTitle(savedObject) {
      return `Investigation: [${savedObject.attributes.title}]`;
    }
  }
};