"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalInvestigateAppServerRouteRepository = getGlobalInvestigateAppServerRouteRepository;
var _investigationShared = require("@kbn/investigation-shared");
var _create_investigation = require("../services/create_investigation");
var _create_investigation_item = require("../services/create_investigation_item");
var _create_investigation_note = require("../services/create_investigation_note");
var _delete_investigation = require("../services/delete_investigation");
var _delete_investigation_item = require("../services/delete_investigation_item");
var _delete_investigation_note = require("../services/delete_investigation_note");
var _find_investigations = require("../services/find_investigations");
var _get_all_investigation_tags = require("../services/get_all_investigation_tags");
var _get_investigation = require("../services/get_investigation");
var _get_investigation_items = require("../services/get_investigation_items");
var _get_investigation_notes = require("../services/get_investigation_notes");
var _investigation_repository = require("../services/investigation_repository");
var _update_investigation = require("../services/update_investigation");
var _get_events = require("../services/get_events");
var _get_alerts_client = require("../services/get_alerts_client");
var _update_investigation_item = require("../services/update_investigation_item");
var _update_investigation_note = require("../services/update_investigation_note");
var _create_investigate_app_server_route = require("./create_investigate_app_server_route");
var _get_all_investigation_stats = require("../services/get_all_investigation_stats");
var _get_entities = require("../services/get_entities");
var _create_entities_es_client = require("../clients/create_entities_es_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createInvestigationRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'POST /api/observability/investigations 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.createInvestigationParamsSchema,
  handler: async ({
    params,
    context,
    request,
    logger
  }) => {
    const user = (await context.core).coreStart.security.authc.getCurrentUser(request);
    if (!user) {
      throw new Error('User is not authenticated');
    }
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _create_investigation.createInvestigation)(params.body, {
      repository,
      user
    });
  }
});
const findInvestigationsRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'GET /api/observability/investigations 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.findInvestigationsParamsSchema,
  handler: async params => {
    var _params$params$query, _params$params;
    const soClient = (await params.context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger: params.logger
    });
    return await (0, _find_investigations.findInvestigations)((_params$params$query = (_params$params = params.params) === null || _params$params === void 0 ? void 0 : _params$params.query) !== null && _params$params$query !== void 0 ? _params$params$query : {}, repository);
  }
});
const getInvestigationRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'GET /api/observability/investigations/{investigationId} 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.getInvestigationParamsSchema,
  handler: async ({
    params,
    context,
    logger
  }) => {
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _get_investigation.getInvestigation)(params.path, repository);
  }
});
const updateInvestigationRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'PUT /api/observability/investigations/{investigationId} 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.updateInvestigationParamsSchema,
  handler: async ({
    params,
    context,
    request,
    logger
  }) => {
    var _params$body;
    const user = (await context.core).coreStart.security.authc.getCurrentUser(request);
    if (!user) {
      throw new Error('User is not authenticated');
    }
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _update_investigation.updateInvestigation)(params.path.investigationId, (_params$body = params.body) !== null && _params$body !== void 0 ? _params$body : {}, {
      repository,
      user
    });
  }
});
const deleteInvestigationRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'DELETE /api/observability/investigations/{investigationId} 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.deleteInvestigationParamsSchema,
  handler: async ({
    params,
    context,
    logger
  }) => {
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _delete_investigation.deleteInvestigation)(params.path.investigationId, repository);
  }
});
const createInvestigationNoteRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'POST /api/observability/investigations/{investigationId}/notes 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.createInvestigationNoteParamsSchema,
  handler: async ({
    params,
    context,
    request,
    logger
  }) => {
    const user = (await context.core).coreStart.security.authc.getCurrentUser(request);
    if (!user) {
      throw new Error('User is not authenticated');
    }
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _create_investigation_note.createInvestigationNote)(params.path.investigationId, params.body, {
      repository,
      user
    });
  }
});
const getAllInvestigationTagsRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'GET /api/observability/investigations/_tags 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.getAllInvestigationTagsParamsSchema,
  handler: async ({
    params,
    context,
    request,
    logger
  }) => {
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _get_all_investigation_tags.getAllInvestigationTags)(repository);
  }
});
const getAllInvestigationStatsRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'GET /api/observability/investigations/_stats 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.getAllInvestigationStatsParamsSchema,
  handler: async ({
    params,
    context,
    request,
    logger
  }) => {
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _get_all_investigation_stats.getAllInvestigationStats)(repository);
  }
});
const getInvestigationNotesRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'GET /api/observability/investigations/{investigationId}/notes 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.getInvestigationNotesParamsSchema,
  handler: async ({
    params,
    context,
    request,
    logger
  }) => {
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _get_investigation_notes.getInvestigationNotes)(params.path.investigationId, repository);
  }
});
const updateInvestigationNoteRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'PUT /api/observability/investigations/{investigationId}/notes/{noteId} 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.updateInvestigationNoteParamsSchema,
  handler: async ({
    params,
    context,
    request,
    logger
  }) => {
    const user = (await context.core).coreStart.security.authc.getCurrentUser(request);
    if (!user) {
      throw new Error('User is not authenticated');
    }
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _update_investigation_note.updateInvestigationNote)(params.path.investigationId, params.path.noteId, params.body, {
      repository,
      user
    });
  }
});
const deleteInvestigationNoteRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'DELETE /api/observability/investigations/{investigationId}/notes/{noteId} 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.deleteInvestigationNoteParamsSchema,
  handler: async ({
    params,
    context,
    request,
    logger
  }) => {
    const user = (await context.core).coreStart.security.authc.getCurrentUser(request);
    if (!user) {
      throw new Error('User is not authenticated');
    }
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _delete_investigation_note.deleteInvestigationNote)(params.path.investigationId, params.path.noteId, {
      repository,
      user
    });
  }
});
const createInvestigationItemRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'POST /api/observability/investigations/{investigationId}/items 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.createInvestigationItemParamsSchema,
  handler: async ({
    params,
    context,
    request,
    logger
  }) => {
    const user = (await context.core).coreStart.security.authc.getCurrentUser(request);
    if (!user) {
      throw new Error('User is not authenticated');
    }
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _create_investigation_item.createInvestigationItem)(params.path.investigationId, params.body, {
      repository,
      user
    });
  }
});
const getInvestigationItemsRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'GET /api/observability/investigations/{investigationId}/items 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.getInvestigationItemsParamsSchema,
  handler: async ({
    params,
    context,
    request,
    logger
  }) => {
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _get_investigation_items.getInvestigationItems)(params.path.investigationId, repository);
  }
});
const updateInvestigationItemRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'PUT /api/observability/investigations/{investigationId}/items/{itemId} 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.updateInvestigationItemParamsSchema,
  handler: async ({
    params,
    context,
    request,
    logger
  }) => {
    const user = (await context.core).coreStart.security.authc.getCurrentUser(request);
    if (!user) {
      throw new Error('User is not authenticated');
    }
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _update_investigation_item.updateInvestigationItem)(params.path.investigationId, params.path.itemId, params.body, {
      repository,
      user
    });
  }
});
const deleteInvestigationItemRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'DELETE /api/observability/investigations/{investigationId}/items/{itemId} 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.deleteInvestigationItemParamsSchema,
  handler: async ({
    params,
    context,
    request,
    logger
  }) => {
    const user = (await context.core).coreStart.security.authc.getCurrentUser(request);
    if (!user) {
      throw new Error('User is not authenticated');
    }
    const soClient = (await context.core).savedObjects.client;
    const repository = (0, _investigation_repository.investigationRepositoryFactory)({
      soClient,
      logger
    });
    return await (0, _delete_investigation_item.deleteInvestigationItem)(params.path.investigationId, params.path.itemId, {
      repository,
      user
    });
  }
});
const getEventsRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'GET /api/observability/events 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.getEventsParamsSchema,
  handler: async ({
    params,
    context,
    request,
    plugins
  }) => {
    const annotationsClient = await plugins.observability.setup.getScopedAnnotationsClient(context, request);
    const alertsClient = await (0, _get_alerts_client.getAlertsClient)({
      plugins,
      request
    });
    const events = [];
    if (annotationsClient) {
      var _params$query;
      const annotationEvents = await (0, _get_events.getAnnotationEvents)((_params$query = params === null || params === void 0 ? void 0 : params.query) !== null && _params$query !== void 0 ? _params$query : {}, annotationsClient);
      events.push(...annotationEvents);
    }
    if (alertsClient) {
      var _params$query2;
      const alertEvents = await (0, _get_events.getAlertEvents)((_params$query2 = params === null || params === void 0 ? void 0 : params.query) !== null && _params$query2 !== void 0 ? _params$query2 : {}, alertsClient);
      events.push(...alertEvents);
    }
    return events;
  }
});
const getEntitiesRoute = (0, _create_investigate_app_server_route.createInvestigateAppServerRoute)({
  endpoint: 'GET /api/observability/investigation/entities 2023-10-31',
  options: {
    tags: []
  },
  params: _investigationShared.getEntitiesParamsSchema,
  handler: async ({
    params,
    context,
    request
  }) => {
    var _params$query3;
    const core = await context.core;
    const esClient = core.elasticsearch.client.asCurrentUser;
    const entitiesEsClient = (0, _create_entities_es_client.createEntitiesESClient)({
      request,
      esClient
    });
    const {
      'service.name': serviceName,
      'service.environment': serviceEnvironment,
      'container.id': containerId,
      'host.name': hostName
    } = (_params$query3 = params === null || params === void 0 ? void 0 : params.query) !== null && _params$query3 !== void 0 ? _params$query3 : {};
    const {
      entities
    } = await (0, _get_entities.getEntitiesWithSource)({
      serviceName,
      serviceEnvironment,
      containerId,
      hostName,
      entitiesEsClient,
      esClient
    });
    return {
      entities
    };
  }
});
function getGlobalInvestigateAppServerRouteRepository() {
  return {
    ...createInvestigationRoute,
    ...findInvestigationsRoute,
    ...getInvestigationRoute,
    ...updateInvestigationRoute,
    ...deleteInvestigationRoute,
    ...createInvestigationNoteRoute,
    ...getInvestigationNotesRoute,
    ...updateInvestigationNoteRoute,
    ...deleteInvestigationNoteRoute,
    ...createInvestigationItemRoute,
    ...deleteInvestigationItemRoute,
    ...updateInvestigationItemRoute,
    ...getInvestigationItemsRoute,
    ...getEventsRoute,
    ...getEntitiesRoute,
    ...getAllInvestigationStatsRoute,
    ...getAllInvestigationTagsRoute
  };
}