"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigateAppPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _register_routes = require("./routes/register_routes");
var _investigation = require("./saved_objects/investigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InvestigateAppPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    this.logger = context.logger.get();
    this.config = context.config.get();
  }
  setup(coreSetup, pluginsSetup) {
    const routeHandlerPlugins = (0, _lodash.mapValues)(pluginsSetup, (value, key) => {
      return {
        setup: value,
        start: () => coreSetup.getStartServices().then(services => {
          const [, pluginsStartContracts] = services;
          return pluginsStartContracts[key];
        })
      };
    });
    if (this.config.enabled === true) {
      coreSetup.savedObjects.registerType(_investigation.investigation);
      (0, _register_routes.registerServerRoutes)({
        core: coreSetup,
        logger: this.logger,
        dependencies: {
          plugins: routeHandlerPlugins
        }
      });
    }
    return {};
  }
  start(core, pluginsStart) {
    return {};
  }
}
exports.InvestigateAppPlugin = InvestigateAppPlugin;