"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensAttrsForSuggestion = getLensAttrsForSuggestion;
var _visualizationUtils = require("@kbn/visualization-utils");
var _lodash = require("lodash");
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLensAttrsForSuggestion({
  query,
  suggestion,
  dataView,
  table
}) {
  const attrs = (0, _visualizationUtils.getLensAttributesFromSuggestion)({
    filters: [],
    query: {
      esql: query
    },
    suggestion,
    dataView
  });
  const lensEmbeddableInput = {
    attributes: attrs,
    id: (0, _uuid.v4)()
  };
  if (!table) {
    return lensEmbeddableInput;
  }
  const textBased = attrs.state.datasourceStates.textBased;
  if (!(textBased !== null && textBased !== void 0 && textBased.layers)) {
    throw new Error('Expected layers to exist for datasourceStates.textBased');
  }
  textBased.layers = (0, _lodash.mapValues)(textBased.layers, value => {
    return {
      ...value,
      table
    };
  });
  return lensEmbeddableInput;
}