"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDatatableFromEsqlResponse = getDatatableFromEsqlResponse;
var _get_kibana_columns = require("./get_kibana_columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDatatableFromEsqlResponse({
  columns,
  values,
  all_columns: allColumns
}) {
  const kibanaColumns = (0, _get_kibana_columns.getKibanaColumns)(allColumns !== null && allColumns !== void 0 ? allColumns : columns);
  const datatable = {
    columns: kibanaColumns,
    rows: values.map(row => {
      return row.reduce((prev, current, index) => {
        const column = columns[index];
        prev[column.name] = current;
        return prev;
      }, {});
    }),
    type: 'datatable',
    meta: {
      type: 'esql'
    }
  };
  return datatable;
}