"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationsError = InvestigationsError;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvestigationsError() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "error",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.investigateApp.InvestigationsNotFound.title', {
      defaultMessage: 'Unable to load investigations'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.investigateApp.InvestigationsNotFound.body', {
      defaultMessage: 'There was an error loading the investigations. Contact your administrator for help.'
    }))
  });
}