"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationStats = InvestigationStats;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_fetch_all_investigation_stats = require("../../../hooks/use_fetch_all_investigation_stats");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvestigationStats() {
  const {
    core: {
      uiSettings
    }
  } = (0, _use_kibana.useKibana)();
  const {
    data,
    isLoading: isStatsLoading
  } = (0, _use_fetch_all_investigation_stats.useFetchAllInvestigationStats)();
  const numberFormat = uiSettings.get('format:number:defaultPattern');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: (0, _numeral.default)(data === null || data === void 0 ? void 0 : data.count.triage).format(numberFormat),
    description: _i18n.i18n.translate('xpack.investigateApp.investigationList.stats.triageLabel', {
      defaultMessage: 'Triage'
    }),
    titleSize: "s",
    isLoading: isStatsLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: (0, _numeral.default)(data === null || data === void 0 ? void 0 : data.count.active).format(numberFormat),
    description: _i18n.i18n.translate('xpack.investigateApp.investigationList.stats.activeLabel', {
      defaultMessage: 'Active'
    }),
    titleSize: "s",
    isLoading: isStatsLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: (0, _numeral.default)(data === null || data === void 0 ? void 0 : data.count.cancelled).format(numberFormat),
    description: _i18n.i18n.translate('xpack.investigateApp.investigationList.stats.cancelledLabel', {
      defaultMessage: 'Cancelled'
    }),
    titleSize: "s",
    isLoading: isStatsLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: (0, _numeral.default)(data === null || data === void 0 ? void 0 : data.count.mitigated).format(numberFormat),
    description: _i18n.i18n.translate('xpack.investigateApp.investigationList.stats.mitigatedLabel', {
      defaultMessage: 'Mitigated'
    }),
    titleSize: "s",
    isLoading: isStatsLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: (0, _numeral.default)(data === null || data === void 0 ? void 0 : data.count.resolved).format(numberFormat),
    description: _i18n.i18n.translate('xpack.investigateApp.investigationList.stats.resolvedLabel', {
      defaultMessage: 'Resolved'
    }),
    titleSize: "s",
    isLoading: isStatsLoading
  }))));
}