"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationListActions = InvestigationListActions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_delete_investigation = require("../../../hooks/use_delete_investigation");
var _investigation_edit_form = require("../../../components/investigation_edit_form/investigation_edit_form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvestigationListActions({
  investigation
}) {
  const [isEditFormFlyoutVisible, setEditFormFlyoutVisible] = (0, _react.useState)(false);
  const [isDeleteModalVisible, setIsDeleteModalVisible] = (0, _react.useState)(false);
  const {
    mutate: deleteInvestigation,
    isLoading: isDeleting,
    isError,
    isSuccess
  } = (0, _use_delete_investigation.useDeleteInvestigation)();
  const closeDeleteModal = () => setIsDeleteModalVisible(false);
  (0, _react.useEffect)(() => {
    if (isError || isSuccess) {
      closeDeleteModal();
    }
  }, [isError, isSuccess]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, isDeleteModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: closeDeleteModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, _i18n.i18n.translate('xpack.investigateApp.deleteModal.title', {
    defaultMessage: 'Delete'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, _i18n.i18n.translate('xpack.investigateApp.deleteModal.description', {
    defaultMessage: "You can't recover this investigation after deletion."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeDeleteModal,
    "data-test-subj": "investigateAppInvestigationListDeleteModalCancelButton"
  }, _i18n.i18n.translate('xpack.investigateApp.deleteModal.cancel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "investigateAppInvestigationListDeleteModalConfirmButton",
    onClick: () => {
      deleteInvestigation({
        investigationId: investigation.id
      });
    },
    fill: true,
    color: "danger",
    isLoading: isDeleting
  }, _i18n.i18n.translate('xpack.investigateApp.deleteModal.confirm', {
    defaultMessage: 'Delete'
  })))))), isEditFormFlyoutVisible && investigation && /*#__PURE__*/_react.default.createElement(_investigation_edit_form.InvestigationEditForm, {
    investigationId: investigation.id,
    onClose: () => setEditFormFlyoutVisible(false)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.investigateApp.investigationList.editAction', {
      defaultMessage: 'Edit'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "investigateAppInvestigationListEditButton",
    "aria-label": _i18n.i18n.translate('xpack.investigateApp.investigationList.editAction.ariaLabel', {
      defaultMessage: 'Edit investigation "{name}"',
      values: {
        name: investigation.title
      }
    }),
    iconType: "pencil",
    onClick: () => setEditFormFlyoutVisible(true)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.investigateApp.investigationList.deleteAction', {
      defaultMessage: 'Delete'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "investigateAppInvestigationListDeleteButton",
    "aria-label": _i18n.i18n.translate('xpack.investigateApp.investigationList.deleteAction.ariaLabel', {
      defaultMessage: 'Delete investigation "{name}"',
      values: {
        name: investigation.title
      }
    }),
    iconType: "trash",
    onClick: () => setIsDeleteModalVisible(true)
  })));
}