"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationSearchBar = InvestigationSearchBar;
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parentClassName = (0, _css.css)`
  width: 100%;
`;
function InvestigationSearchBar({
  dateRangeFrom,
  dateRangeTo,
  onQuerySubmit,
  onRefresh
}) {
  const {
    dependencies: {
      start: {
        unifiedSearch
      }
    }
  } = (0, _use_kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: parentClassName
  }, /*#__PURE__*/_react.default.createElement(unifiedSearch.ui.SearchBar, {
    appName: "investigate",
    onQuerySubmit: ({
      dateRange
    }) => {
      onQuerySubmit({
        dateRange
      });
    },
    showQueryInput: false,
    showFilterBar: false,
    showQueryMenu: false,
    showDatePicker: true,
    showSubmitButton: true,
    dateRangeFrom: dateRangeFrom,
    dateRangeTo: dateRangeTo,
    onRefresh: onRefresh,
    displayStyle: "inPage",
    disableQueryLanguageSwitcher: true
  }));
}